(function() {

    u.register({
        /**
         * Вставляет в текст с длинными словами элементы <wbr/>, позволяя браузеру переносить части слов на другую строку
         * @param {String} text
         * @param {Number} [chunkSize]
         * @returns {String}
         */
        splitText: function(text, chunkSize) {
            chunkSize = chunkSize || 25;
            text = text || '';

            var parts = text.replace(/([\s,\.\-\/])/g, '$1\u0001').split('\u0001'),
                splitParts = [];

            parts.forEach(function(part, i) {
                var tmpPart;

                while (part.length > chunkSize) {
                    tmpPart = Math.min(chunkSize, part.length / 2);
                    splitParts.push(part.substring(0, tmpPart));
                    part = part.substring(tmpPart);
                }

                splitParts.push(part);
            });

            splitParts = splitParts.map(function(str) {
                return u.escapeHTML(str);
            });

            return splitParts.join('<wbr />');
        }
    });
}());
