(function(u) {
    var MAX_COLUMN_CHART_POINTS = 65;

    /**
     * Предобработка данных статистики
     * @param {String} curr валюта
     * @param {Array} data - массив исходных данных
     * @param {Object} platforms - платформы показа
     * @returns {Array} массив данных в highcharts-формате
     */
    function processDataForCharts(curr, data, platforms) {
        var points = data.length,
            currency = u.currencies.getName(curr),
            ids = ['sum', 'av_sum', 'clicks', 'shows', 'ctr'],
            mod = '';

        if (platforms.net && !platforms.search && !platforms.all) {
            mod = '_1';
        } else if (platforms.search && !platforms.net && !platforms.all) {
            mod = '_0';
        }

        ids = ids.map(function(id) {
            return id += mod;
        });

        return _prepareChartData(
            [{
                // синий
                name: iget2('i-utils', 'obshchiy-rashod-po-kampanii', 'Общий расход по кампании') + ', ' + currency,
                id: ids[0],
                color: '#77b6e7',
                fillOpacity: 0.2,
                visible: false
            }, { // фиолетовый
                name: iget2('i-utils', 'srednyaya-cena-klika', 'Средняя цена клика') + ', ' + currency,
                id: ids[1],
                color: '#a955b8',
                fillOpacity: 0.5,
                visible: false
            }, { //зеленый
                id: ids[2],
                name: iget2('i-utils', 'kliki', 'Клики'),
                color: '#97cc64',
                fillOpacity: 0.5,
                visible: true
            }, { // желтый
                id: ids[3],
                name: iget2('i-utils', 'pokazy', 'Показы'),
                color: '#ffd963',
                fillOpacity: 0.2,
                visible: true
            }, { //красный
                id: ids[4],
                name: iget2('i-utils', 'ctr', 'CTR(%)'),
                type: points < MAX_COLUMN_CHART_POINTS ? 'spline' : 'areaspline',
                color: '#fd5a3e',
                fillOpacity: 0.2,
                visible: true
            }], data);
    }

    /**
     * Метод превращает любые данные из массива данных статистики в highcharts-съедобные
     * @param {Array.<{name: String, id: String, color: String, fillOpacity: Number, type: String, processor: function}>} fieldsList
     * - массив объект-паттернов для разбора
     * @param {String} statData - массив данных от статистики
     * @returns {Array} данные для highcharts
     * @private
     */
    function _prepareChartData(fieldsList, statData) {
        var data = [];
        fieldsList.forEach(function(field) {
            var pattern;
            pattern = {
                name: field.name,
                data: [],
                color: field.color,
                fillOpacity: field.fillOpacity,
                visible: field.visible
            };
            if (field.type) { pattern.type = field.type }
            data.push(pattern);
            statData.forEach(function(rowData) {
                var date = u.moment(rowData.stat_date, 'YYYY-MM-DD').valueOf();
                pattern.data.push({
                    x: date,
                    y: Number(rowData[field.id])
                });
            }, this);
            pattern.data = u._.sortBy(pattern.data, function(row) {
                return row.x;
            })
        }, this);
        return data;
    }

    u.register({
        statistics: u._.extend({}, {
            processDataForCharts: processDataForCharts
        })
    })
})(u);
