describe('i-utils__statistics', function() {
    // делаем тесты независимыми от настроек часового пояса
    var offset = new Date().getTimezoneOffset() * 60000 + 10800000;

    var data = [
        {
            stat_date: '2015-09-02',
            ctr: 1,
            clicks: 2,
            av_sum: 3,
            sum: 4,
            shows: 5
        },
        {
            stat_date: '2015-09-01',
            ctr: 1,
            clicks: 2,
            av_sum: 3,
            sum: 4,
            shows: 5
        },
        {
            stat_date: '2015-08-02',
            ctr: 1,
            clicks: 2,
            av_sum: 3,
            sum: 4,
            shows: 5
        },
        {
            stat_date: '2015-09-10',
            ctr: 1,
            clicks: 2,
            av_sum: 3,
            sum: 4,
            shows: 5
        }
    ];

    it('Корректно обрабатываются данные', function() {
        expect(u.statistics.processDataForCharts('RUB', data, { all: 1, net:0, search: 0 })).to.deep.equal(
            [
                {
                    "name": "Общий расход по кампании, руб.",
                    "data": [
                        {
                            "x": 1438462800000 + offset,
                            "y": 4
                        },
                        {
                            "x": 1441054800000 + offset,
                            "y": 4
                        },
                        {
                            "x": 1441141200000 + offset,
                            "y": 4
                        },
                        {
                            "x": 1441832400000 + offset,
                            "y": 4
                        }
                    ],
                    "color": "#77b6e7",
                    "fillOpacity": 0.2,
                    "visible": false
                },
                {
                    "name": "Средняя цена клика, руб.",
                    "data": [
                        {
                            "x": 1438462800000 + offset,
                            "y": 3
                        },
                        {
                            "x": 1441054800000 + offset,
                            "y": 3
                        },
                        {
                            "x": 1441141200000 + offset,
                            "y": 3
                        },
                        {
                            "x": 1441832400000 + offset,
                            "y": 3
                        }
                    ],
                    "color": "#a955b8",
                    "fillOpacity": 0.5,
                    "visible": false
                },
                {
                    "name": "Клики",
                    "data": [
                        {
                            "x": 1438462800000 + offset,
                            "y": 2
                        },
                        {
                            "x": 1441054800000 + offset,
                            "y": 2
                        },
                        {
                            "x": 1441141200000 + offset,
                            "y": 2
                        },
                        {
                            "x": 1441832400000 + offset,
                            "y": 2
                        }
                    ],
                    "color": "#97cc64",
                    "fillOpacity": 0.5,
                    "visible": true
                },
                {
                    "name": "Показы",
                    "data": [
                        {
                            "x": 1438462800000 + offset,
                            "y": 5
                        },
                        {
                            "x": 1441054800000 + offset,
                            "y": 5
                        },
                        {
                            "x": 1441141200000 + offset,
                            "y": 5
                        },
                        {
                            "x": 1441832400000 + offset,
                            "y": 5
                        }
                    ],
                    "color": "#ffd963",
                    "fillOpacity": 0.2,
                    "visible": true
                },
                {
                    "name": "CTR(%)",
                    "data": [
                        {
                            "x": 1438462800000 + offset,
                            "y": 1
                        },
                        {
                            "x": 1441054800000 + offset,
                            "y": 1
                        },
                        {
                            "x": 1441141200000 + offset,
                            "y": 1
                        },
                        {
                            "x": 1441832400000 + offset,
                            "y": 1
                        }
                    ],
                    "color": "#fd5a3e",
                    "fillOpacity": 0.2,
                    "visible": true,
                    "type": "spline"
                }
            ]
        )
    });
});
