describe('i-utils__subway-station', function() {
    describe('getNameSubwayStation', function() {
        before(function() {
            u.stub(u, {
                getMetroCollection: function() {
                    return [
                        {
                            city: "Москва",
                            city_id: "1",
                            metro: [
                                {
                                    region_id: 20490,
                                    name: 'Парк культуры'
                                }
                            ]
                        }
                    ];
                }
            });
        });

        after(function() {
            u.restore(u);
        });

        it('должен возвращать имя станции метро по индентификатору', function() {
            var metroName = u.getNameSubwayStation('20490');

            expect(metroName).to.equal('Парк культуры');
        });
    });
});
