(function() {
    var glob = {
            'metro.js': function(data) {
                return data;
            }
        },
        /*jshint -W054*/
        stations = (new Function('window', 'return ' + 'borschik:include:../../desktop.blocks/i-utils/__subway-station/i-utils__subway-station.data.js')).call(this, glob);

    u.register({

        /**
         * Возвращает коллекцию станций метро для доступных городов
         * @returns {Object}
         */
        getMetroCollection: function() {
            return stations;
        },

        /**
         * Возвращает название станции метро по ее идентификатору
         * @param {String} metroId идентификатор станции метро
         * @returns {*}
         */
        getNameSubwayStation: function(metroId) {
            var result = '';

            u.getMetroCollection().some(function(cityHash) {
                return cityHash.metro.some(function(metro) {
                    if (metro.region_id == metroId) {
                        result = metro.name;

                        return true;
                    } else {
                        return false;
                    }
                });
            });

            return result;
        }

    });

})();
