(function() {
    u.register({
        table: {
            /**
             * Формирует ссылку для сортировки таблицы по заданной колонке
             * Аналог perl функции get_sort_table_header
             *
             * @typedef {Object} urlOptions
             * @property {String} anchor якорь для ссылки a name="anchor_name"
             * @property {Boolean} dontRemovePageFromUrl если true то параметр page будет добавлен в href ссылки из формы
             * @property {Boolean} defaultReverse если true, то сортировка будет обратной к сортировке по умолчанию
             * @property {Boolean} anchorset если true, будет проставлен anchor
             * @property {String} urlParam постфикс будет добавлен к параметрам ссылки sort, reverse
             * Н: если urlOptions.options.urlParam='postfix' то href ссылки будет содержать href="...&sortpostfix=...&..."
             *
             * @typedef {Object} headerLinkOptions
             * @property {String} caption текст ссылки
             * @property {String} col имя солонки для сортировки
             * @property {String} defCol имя солонки для сортировки по умолчанию
             * @property {String} script protocol + host + pathname текущей страницы
             * @property {Boolean} [broadcast] признак ссылки без url, которая тригерит событие в канал
             * @property {Object<urlOptions>} options
             *
             * @param {Object<headerLinkOptions>} params
             * @param {Object} [form] GET параметры страницы
             *
             * @returns {string}
             */
            getSortHeaderLink: function(params, form) {
                params = params || {};
                form = form || {};

                var options = params.options || {},
                    caption = params.caption || '',
                    defCol = params.defCol || '',
                    script = params.script || '',
                    col = params.col || '',

                    anchorset = options.anchorset && options.anchor ? ' name="' + options.anchor + '" ' : ' ',
                    classes = options.classes || '',
                    metrikaGoal = options.metrikaGoal,
                    dataBem = {},
                    urlParamSort = options.urlParam ? 'sort' + options.urlParam : 'sort',
                    urlParamReverse = options.urlParam ? 'reverse' + options.urlParam : 'reverse',
                    removePageParam = options.dontRemovePageFromUrl ? '' : 'page',
                    sortUrlKeys = [urlParamSort, urlParamReverse, 'ncrnd', 'UID', 'ouid_url', removePageParam],
                    sort = encodeURIComponent(form[urlParamSort] || '') ||
                        (Array.isArray(defCol) ? defCol.join(',') : defCol),
                    cols = encodeURIComponent(Array.isArray(col) ? col.join(',') : col),
                    anchor = options.anchor ? '#' + options.anchor : '',
                    defaultReverse = options.defaultReverse ? 1 : 0,
                    drawReverse = form[urlParamReverse] !== undefined ?
                        +encodeURIComponent(form[urlParamReverse]) :
                        defaultReverse,
                    arrowChar = drawReverse ? (params.downArrow) || '&darr;' : (params.upArrow) || '&uarr;',
                    arrowText = '',
                    newReverse = defaultReverse,

                    sorturl = Object.keys(form).reduce(function(res, key) {
                        if (sortUrlKeys.indexOf(key) < 0) {
                            var component = encodeURIComponent(form[key]);

                            // TODO: разобраться с encodeURIComponent и null
                            // кто: belyanskii
                            // костыль!
                            // мы не должны передавать null на сервер,
                            // перловая функция так не поступает.
                            if (component === 'null') {
                                component = '';
                            }

                            res += encodeURIComponent(key) + '=' + component + '&';
                        }

                        return res;
                    }, ''),
                    url = '';

                if (cols == sort) {
                    arrowText = '&nbsp;<small style="color: #707070;">' + arrowChar + '</small>';

                    newReverse = 1 - drawReverse;
                }

                if (params.broadcast) {
                    classes += ' i-bem link link_action_broadcast ';
                    dataBem.link = {
                        eventName: 'stat-table-sort',
                        eventData: {
                            sort: cols,
                            reverse: newReverse
                        }
                    };
                }

                if (metrikaGoal) {
                    classes += ' b-metrika ';

                    if (!dataBem.link) {
                        classes += ' i-bem link ';
                        dataBem.link = {};
                    }

                    dataBem['b-metrika'] = {
                        goal: metrikaGoal,
                        counter: '34'
                    };
                }

                if (!params.broadcast) {
                    url = ' href="' + script + '?' + sorturl + urlParamSort + '=' + cols + '&' + urlParamReverse + '=' + newReverse + anchor + '" ';
                }

                return '<a' + anchorset + url +
                    ' class="' + classes + '" ' +
                    ' data-bem=\'' + JSON.stringify(dataBem) + '\'' +
                    '>' + caption + '</a>' + arrowText;
            },

            /**
             * Сортирует переданный массив данных по полям указанным в form.sort или defCol
             * наличие одного из них обязательно
             * Используется для сортировки табличных данных в b-campaigns-list
             *
             * @param {Object[]} data массив объектов для сортировки
             * @param {Object} [form]
             * @param {String} [form.sort] поле либо поля разделенные запятой по которым будет производится сортировка
             * @param {String|String[]} [defCol] поле либо поля по которым будет производится сортировка
             * @param {String[]} [colsWithStrSort] поля которые нужно сравнивать построчно
             *
             * @returns {Object[]}
             */
            sortData: function(data, form, defCol, colsWithStrSort) {
                if (!Array.isArray(data)) {
                    return data;
                }

                var stringSort = {},
                    col = [],
                    coll = {};

                (colsWithStrSort || []).forEach(function(columnName) {
                    stringSort[columnName] = 1;
                });

                col = form.sort ?
                    form.sort.split(',') :
                    Array.isArray(defCol) ? defCol : [defCol];

                col.forEach(function(colsort) {
                    coll[colsort] = 1;
                });

                return data.sort(function(a, b) {

                    if (coll.mauid) {
                        //если сравнение по полю mauid сравниваем по ManagerUID и AgencyUID и выходим
                        a = +a.ManagerUID || +a.AgencyUID || 0;
                        b = +b.ManagerUID || +b.AgencyUID || 0;

                        return a - b;
                    }

                    return compareByColumns(a, b, col, stringSort, !!+(form.reverse));
                });
            }

        }
    });

    /**
     * Сравнивает 2 объекта строки по переданным полям
     *
     * @param {Object} a
     * @param {Object} b
     * @param {String[]} cols поля для сравнения объектов
     * @param {Object} stringSort хеш для строкового сравнения.
     * Ключ хеша  - имя поля которое нужно сравнивать построчно: { field_name: 1 }
     * @param {Boolean} [reverseSort] если true вывод в порядке убывания
     *
     * @returns {Number}
     */
    var compareByColumns = function(a, b, cols, stringSort, reverseSort) {
        var res = 0;

        //ходим по вложенным хешам
        cols.some(function(colname) {
            var aVal, bVal;

            if (stringSort[colname]) {
                aVal = (u._.get(a, colname, '') + '').toLowerCase();
                bVal = (u._.get(b, colname, '') + '').toLowerCase();

                res = aVal.localeCompare(bVal);
            } else {
                aVal = parseFloat(u._.get(a, colname, 0)) || 0;
                bVal = parseFloat(u._.get(b, colname, 0)) || 0;

                res = aVal - bVal;
            }

            return res;
        });

        return reverseSort ? -res : res;
    };

}());
