(function() {
    /**
     * Добавляет приставку Post-click включенной фиче post_view_statistics
     * @param {String} title
     * @param {boolean} isAvailable
     * @return {String}
     */
    function placePostClick(title, isAvailable) {
        return (isAvailable && u.hasClientFeature('post_view_statistics')) ? 'Post-click: ' + title : title;
    }

    /**
     * Добавляет приставку Post-view включенной фиче post_view_statistics
     * @param {String} title
     * @return {String}
     */
    function placePostView(title) {
        return 'Post-view: ' + title;
    }

    var initStore = function() {
        var SUPPORTING_STORE = {
                banner: {
                    shouldNotBeBlank: {
                        text: iget2(
                            'i-utils',
                            'banners-title-should-not-be-blank',
                            'Поле обязательно для заполнения'
                        )
                    },
                    adTextFields: {
                        'BannerDefectIds.Gen.INVALID_TEMPLATE_QUERY': {
                            text: iget2(
                                'i-utils',
                                'banners-title-invalid-template-query',
                                'Можно использовать шаблон только один раз'
                            )
                        },
                        'BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD': {
                            text: iget2(
                                'i-utils',
                                'banners-restricted-chars-in-field',
                                'Можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, цифры и знаки пунктуации'
                            )
                        },
                        'BannerDefectIds.String.TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX': {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'banners-text-length-without-template-marker-cannot-be-more-than-max',
                                    'Превышена допустимая длина в {max} символов',
                                    { max: params.backendParams.maxLength }
                                );
                            }
                        },
                        'BannerDefectIds.String.LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX': {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'banners-length-word-without-template-marker-cannot-be-more-than-max',
                                    'Недопустимы слова длиной более {max} символов',
                                    { max: params.backendParams.maxLength }
                                );
                            }
                        },
                        'BannerDefectIds.String.MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX': {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'banners-max-number-of-narrow-characters-cannot-be-more-than-max',
                                    'Можно использовать не более {max} точек, запятых, двоеточий, точек с запятой, кавычек и восклицательных знаков',
                                    { max: params.backendParams.maxLength }
                                );
                            }
                        },
                        'BannerDefectIds.Gen.ILLEGAL_COMMA': {
                            text: iget2(
                                'i-utils',
                                'banners-illegal-comma',
                                'Неправильное использование знаков препинания'
                            )
                        }
                    },
                    vcard: {
                        MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS: {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'vcard-must-contain-letters-or-digits-or-punctuations',
                                    'В поле «{fieldName}» можно использовать только буквы латинского, турецкого, русского, украинского, белорусского или казахского алфавита, цифры и знаки пунктуации',
                                    { fieldName: params.fieldName }
                                )
                            }
                        },
                        MUST_CONTAIN_LETTERS: {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'vcard-must-contain-letters',
                                    'В поле «{fieldName}» допускается использование букв латинского, турецкого, русского, украинского, белорусского и казахского алфавитов',
                                    { fieldName: params.fieldName }
                                )
                            }
                        },
                        LENGTH_CANNOT_BE_MORE_THAN_MAX: {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'vcard-length-cannot-be-more-than-max',
                                    'Значение в поле «{fieldName}» не должно превышать {maxLength} символов',
                                    {
                                        fieldName: params.fieldName,
                                        maxLength: params.backendParams.maxLength
                                    }
                                )
                            }
                        },
                        COUNTRY_CODE_RULES: {
                            text: iget2(
                                'i-utils',
                                'vcard-country-code-rules',
                                '«Код страны» должен содержать от 1 до 5 символов, начинаться со знака «+» или «8» и состоять из цифр'
                            )
                        }
                    }
                },
                hierarchicalMultipliers: {
                    multiplierPct: {
                        children: {
                            'NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX': {
                                text: function(params) {
                                    return iget2(
                                        'i-utils',
                                        'hierarchical-multipliers-multiplier-pct-must-be-less-then-or-equal-to-max',
                                        'Нельзя увеличить ставку более чем на {max}',
                                        { max: params.backendParams.max }
                                    );
                                }
                            },
                            'NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN': {
                                text: function(params) {
                                    return iget2(
                                        'i-utils',
                                        'hierarchical-multipliers-multiplier-pct-must-be-greater-than-or-equal-to-min',
                                        'Нельзя уменьшить ставку более чем на {min}',
                                        { max: params.backendParams.min }
                                    );
                                }
                            },
                            'BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE': {
                                text: function(params) {
                                    return iget2(
                                        'i-utils',
                                        'hierarchical-multipliers-multiplier-pct-invalid-percent-should-be-positive',
                                        'Отрицательный коэффициент ставки: {value}',
                                        { value: params.value }
                                    );
                                }
                            }
                        }
                    }
                }
            },
            STORE = {
                chart: {
                    children: {
                        others: { text: iget2('i-utils', 'ostalnye', 'Остальные') },
                        shows: { text: iget2('i-utils', 'pokazy', 'Показы') },
                        avg_nshow: { text: iget2('i-utils', 'avg-nshow', 'Заметность показов (%)') },
                        eshows: { text: iget2('i-utils', 'eshows', 'Взвешенные показы') },
                        clicks: { text: iget2('i-utils', 'kliki', 'Клики') },
                        ctr: { text: iget2('i-utils', 'ctr-185', 'CTR') + ' (%)' },
                        ectr: { text: iget2('i-utils', 'wctr', 'wCTR') + ' (%)' },
                        sum: { text: function(params) { return iget2('i-utils', 'rashod-vsego-currency', 'Расход всего ({currency})', params); } },
                        av_sum: { text: function(params) { return iget2('i-utils', 'sr-cena-klika-currency', 'Ср. цена клика ({currency})', params); } },
                        avg_cpm: { text: function(params) { return iget2('i-utils', 'sr-cena-tys-pokazov', 'Ср. цена тыс. показов ({currency})', params); } },
                        fp_shows_avg_pos: { text: iget2('i-utils', 'sr-poziciya-pokaza', 'Ср. позиция показа') },
                        avg_x: { text: iget2('i-utils', 'avg_x', 'Ср. объём трафика') },
                        fp_clicks_avg_pos: { text: iget2('i-utils', 'sr-poziciya-klika', 'Ср. позиция клика') },
                        winrate: { text: iget2('i-utils', 'procent-poluchennyh-pokazov', 'Процент полученных показов (%)') },
                        bounce_ratio: { text: placePostClick(iget2('i-utils', 'otkazy', 'Отказы (%)')) },
                        pv_bounce_ratio: { text: placePostView(iget2('i-utils', 'otkazy', 'Отказы (%)')) },
                        adepth: { text: placePostClick(iget2('i-utils', 'glubina-str', 'Глубина (стр.)')) },
                        pv_adepth: { text: placePostView(iget2('i-utils', 'glubina-str', 'Глубина (стр.)')) },
                        aconv: { text: placePostClick(iget2('i-utils', 'konversiya', 'Конверсия') + ' (%)') },
                        pv_aconv: { text: placePostView(iget2('i-utils', 'konversiya', 'Конверсия') + ' (%)') },
                        avg_time_to_conv: { text: placePostClick(iget2('i-utils', 'avg-time-to-conv', 'Ср. время до конверсии (час.)')) },
                        pv_avg_time_to_conv: { text: placePostView(iget2('i-utils', 'avg-time-to-conv', 'Ср. время до конверсии (час.)')) },
                        agoalcost: { text: function(params) { return placePostClick(iget2('i-utils', 'cena-celi-currency', 'Цена цели ({currency})', params)); } },
                        pv_agoalcost: { text: function(params) { return placePostView(iget2('i-utils', 'cena-celi-currency', 'Цена цели ({currency})', params)); } },
                        agoalnum: { text: placePostClick(iget2('i-utils', 'konversii', 'Конверсии')) },
                        all_agoalnum: { text: iget2('i-utils', 'all-konversii', 'Всего конверсий') },
                        pv_agoalnum: { text: placePostView(iget2('i-utils', 'konversii', 'Конверсии')) },
                        agoalroi: { text: placePostClick(iget2('i-utils', 'rentabelnost-currency2', 'Рентабельность')) },
                        pv_agoalroi: { text: placePostView(iget2('i-utils', 'rentabelnost-currency2', 'Рентабельность')) },
                        agoalcrr: { text: placePostClick(iget2('i-utils', 'crr', 'Доля рекламных расходов (%)')) },
                        pv_agoalcrr: { text: placePostView(iget2('i-utils', 'crr', 'Доля рекламных расходов (%)')) },
                        agoalincome: { text: function(params) { return placePostClick(iget2('i-utils', 'dohod-currency', 'Доход ({currency})', params)); } },
                        pv_agoalincome: { text: function(params) { return placePostView(iget2('i-utils', 'dohod-currency', 'Доход ({currency})', params)); } },
                        agoals_profit: { text: function(params) { return placePostClick(iget2('i-utils', 'agoals-profit', 'Прибыль ({currency})', params)); } },
                        pv_agoals_profit: { text: function(params) { return placePostView(iget2('i-utils', 'agoals-profit', 'Прибыль ({currency})', params)); } },
                        campaign: { text: iget2('i-utils', 'kampanii', 'Кампании') },
                        gender: {
                            text: iget2('i-utils', 'pol', 'Пол'),
                            children: {
                                male: { text: iget2('i-utils', 'muzhskoy', 'Мужской') },
                                female: { text: iget2('i-utils', 'zhenskiy', 'Женский') },
                                undefined: { text: iget2('i-utils', 'ne-opredelen', 'Не определен') }
                            }
                        },
                        targeting_category: {
                            text: iget2('i-utils', 'semantic-correspondence-type', 'Категория таргетинга'),
                            children: {
                                exact: { text: iget2('i-utils', 'celevye-zaprosy', 'Целевые запросы') },
                                alternative: { text: iget2('i-utils', 'alternativnye-zaprosy', 'Альтернативные запросы') },
                                competitor: { text: iget2('i-utils', 'zaprosy-s-upominaniem-konkurentov', 'Запросы с упоминанием конкурентов') },
                                broader: { text: iget2('i-utils', 'shirokie-zaprosy', 'Широкие запросы') },
                                accessory: { text: iget2('i-utils', 'soputstvuyushchie-zaprosy', 'Сопутствующие запросы') },
                                undefined: { text: iget2('i-utils', 'ne-opredelena', 'Не определена') }
                            }
                        },
                        prisma_income_grade: {
                            text: iget2('i-utils', 'prisma-income-grade', 'Уровень платежеспособности'),
                            children: {
                                above_average: { text: iget2('i-utils', 'vishe_srendego', '6-10%') },
                                high: { text: iget2('i-utils', 'visokii_', '2-5%') },
                                very_high: { text: iget2('i-utils', 'ochen_visokii', '1%') },
                                others: { text: iget2('i-utils', 'ostalnye', 'Остальные') }
                            }
                        },
                        age: {
                            text: iget2('i-utils', 'vozrast', 'Возраст'),
                            children: {
                                '0-17': { text: iget2('i-utils', 'mladshe-18', 'Младше 18') },
                                '18-24': { text: iget2('i-utils', '18-24', '18-24') },
                                '25-34': { text: iget2('i-utils', '25-34', '25-34') },
                                '35-44': { text: iget2('i-utils', '35-44', '35-44') },
                                '45-': { text: iget2('i-utils', 'starshe-45', 'Старше 45') },
                                '45-54': { text: iget2('i-utils', '45-54', '45-54') },
                                '55-': { text: iget2('i-utils', 'starshe-55', 'Старше 55') },
                                undefined: { text: iget2('i-utils', 'ne-opredelen', 'Не определен') }
                            }
                        },

                        // Для MCC
                        client_login: { text: iget2('i-utils', 'client-login', 'Аккаунт') },

                        // internal: срезы + фильтры
                        client_id: { text: iget2('i-utils', 'client-id', 'Идентификатор клиента') },
                        place_id: { text: iget2('i-utils', 'place-id', 'Номер плейса') },
                        place_description: { text: iget2('i-utils', 'place-description', 'Описание плейса') },
                        operating_system: { text: iget2('i-utils', 'operating-system', 'Операционная система') },
                        browser: { text: iget2('i-utils', 'browser', 'Браузер') },
                        page_id: { text: iget2('i-utils', 'page-id', 'Номер пейджа') },

                        // internal:фильтры
                        template_id: { text: iget2('i-utils', 'template-id', 'Шаблон') },

                        // internal: столбцы
                        close_clicks: { text: iget2('i-utils', 'close-clicks', 'Клики закрытия') },
                        close_ctr: { text: iget2('i-utils', 'close-ctr', 'CTR закрытия') },

                        campaign_type: {
                            text: iget2('i-utils', 'tip-kampanii', 'Тип кампании'),
                            children: {
                                text: { text: iget2('i-utils', 'tekstovo-graficheskie-obyavleniya', 'Текстово-графические объявления') },
                                dynamic: { text: iget2('i-utils', 'dinamicheskie-obyavleniya', 'Динамические объявления') },
                                mobile_content: { text: iget2('i-utils', 'reklama-mobilnyh-prilozheniy', 'Реклама мобильных приложений') },
                                performance: { text: iget2('i-utils', 'smart-bannery', 'Смарт-баннеры') },
                                content_promotion: { text: iget2('i-utils', 'content-promotion', 'Продвижение контента') },
                                cpm_banner: { text: iget2('i-utils', 'cpm-banner2', 'Медийная кампания') },
                                cpm_deals: { text: iget2('i-utils', 'cpm-deals', 'Медийная кампания со сделками') },
                                cpm_yndx_frontpage: { text: iget2('i-utils', 'cpm-yndx-frontpage', 'Медийная кампания на Главной') },
                                mcbanner: { text: iget2('i-utils', 'mcbanner', 'Баннер на поиске') }
                            }
                        },
                        tags: {
                            text: iget2('i-utils', 'metki', 'Метки'),
                            children: {
                                notSet: { text: iget2('i-utils', 'metki-ne-zadany', 'Метки не заданы') }
                            }
                        },
                        adgroup: { text: iget2('i-utils', 'gruppy', 'Группы') },
                        banner: { text: iget2('i-utils', 'no-obyavleniya', '№ объявления') },
                        banner_status: {
                            text: iget2('i-utils', 'status-obyavleniya', 'Статус объявления'),
                            children: {
                                active: { text: iget2('i-utils', 'aktivnye', 'Активные') },
                                off: { text: iget2('i-utils', 'ostanovlennye', 'Остановленные') },
                                arch: { text: iget2('i-utils', 'arhivnye', 'Архивные') },
                                decline: { text: iget2('i-utils', 'otklonennye', 'Отклоненные') }
                            }
                        },
                        banner_type: {
                            text: iget2('i-utils', 'tip-obyavleniya', 'Тип объявления'),
                            children: {
                                text: { text: iget2('i-utils', 'tekstovo-graficheskie', 'Текстово-графические') },
                                image_ad: { text: iget2('i-utils', 'graficheskie', 'Графические') },
                                other: { text: '–' }
                            }
                        },
                        contextcond_orig: {
                            text: iget2('i-utils', 'uslovie-pokaza', 'Условие показа'),
                            children: {
                                search: { text: iget2('i-utils', 'poisk', 'поиск') },
                                context: { text: iget2('i-utils', 'seti', 'сети') }
                            }
                        },
                        match_type: {
                            text: iget2('i-utils', 'tip-sootvetstviya', 'Тип соответствия'),
                            children: {
                                none: { text: iget2('i-utils', 'bez-tipa-sootvetstviya', 'без типа соответствия') },
                                syn: { text: iget2('i-utils', 'sinonimy', 'синонимы') },
                                rkw: { text: iget2('i-utils', 'drf', 'ДРФ') }
                            }
                        },
                        contexttype_orig: {
                            text: iget2('i-utils', 'tip-usloviya-pokaza', 'Тип условия показа'),
                            children: {
                                phrases: { text: iget2('i-utils', 'frazy', 'фразы') },
                                retargeting: { text: iget2('i-utils', 'usloviya-podbora-auditorii', 'условия подбора аудитории') },
                                dynamic: { text: iget2('i-utils', 'usloviya-nacelivaniya-do', 'условия нацеливания ДО') },
                                performance: { text: iget2('i-utils', 'filtry-smart-bannerov', 'фильтры смарт-баннеров') },
                                'relevance-match': { text: iget2('i-utils', 'avtotargeting', 'автотаргетинг') },
                                notSet: { text: iget2('i-utils', 'ne-opredelen', 'Не определен') }
                            }
                        },
                        criterion_type: {
                            text: iget2('i-utils', 'tip-usloviya-pokaza', 'Тип условия показа'),
                            children: {
                                phrases: { text: iget2('i-utils', 'phrase', 'фраза') },
                                retargeting: { text: iget2('i-utils', 'uslovie-podbora-auditorii', 'условие подбора аудитории') },
                                'webpage-filter': { text: iget2('i-utils', 'filtr-po-saitu', 'фильтр по сайту') },
                                'feed-filter': { text: iget2('i-utils', 'filtr-po-feedu', 'фильтр по фиду') },
                                'mobile-content-interest': { text: iget2('i-utils', 'interes-k-mob-app', 'интерес к мобильным приложениям') },
                                'relevance-match': { text: iget2('i-utils', 'autotargeting', 'автотаргетинг') },
                                'reach-audience': { text: iget2('i-utils', 'interesi-i-socdem', 'интересы и соцдем') },
                                notSet: { text: iget2('i-utils', 'ne-opredelen', 'Не определен') }
                            }
                        },
                        retargeting_coef: {
                            text: iget2('i-utils', 'uslovie-podbora-korrektirovki', 'Условие подбора (корректировки)'),
                            children: {
                                notSet: { text: iget2('i-utils', 'usloviya-podbora-ne-zadany', 'Условия подбора не заданы') }
                            }
                        },
                        targettype: {
                            text: iget2('i-utils', 'tip-ploshchadki', 'Тип площадки'),
                            children: {
                                search: { text: iget2('i-utils', 'poisk', 'поиск') },
                                context: { text: iget2('i-utils', 'seti', 'сети') }
                            }
                        },
                        page_group: { text: iget2('i-utils', 'nazvanie-ploshchadki', 'Название площадки') },
                        page: { text: iget2('i-utils', 'nazvanie-ploshchadki-podrobno', 'Название площадки (подробно)') },
                        ssp: { text: iget2('i-utils', 'vneshnie-seti', 'Внешние сети') },
                        region: { text: iget2('i-utils', 'region-targetinga', 'Регион таргетинга') },
                        physical_region: { text: iget2('i-utils', 'region-mestonahozhdeniya', 'Регион местонахождения') },
                        position: {
                            text: iget2('i-utils', 'placement-type', 'Вид размещения'),
                            children: {
                                1: { text: iget2('i-utils', 'specrazmeshchenie', 'спецразмещение') },
                                2: { text: iget2('i-utils', 'prochee', 'прочее') },
                                102: { text: iget2('i-utils', 'exclusive-position', 'эксклюзивное размещение') },
                                104: { text: iget2('i-utils', 'suggest-position', 'реклама в саджесте') },
                                200: { text: iget2('i-utils', 'adv-gallery', 'товарная галерея') }
                            }
                        },
                        click_place: {
                            text: iget2('i-utils', 'mesto-klika', 'Место клика'),
                            children: {
                                title: { text: iget2('i-utils', 'zagolovok', 'заголовок') },
                                display_href: { text: iget2('i-utils', 'otobrazhaemaya-ssylka', 'отображаемая ссылка') },
                                button: { text: iget2('i-utils', 'knopka', 'кнопка') },
                                vcard: { text: iget2('i-utils', 'vizitka', 'визитка') },
                                sitelink1: { text: iget2('i-utils', 'bystraya-ssylka', 'быстрая ссылка') + ' 1' },
                                sitelink2: { text: iget2('i-utils', 'bystraya-ssylka', 'быстрая ссылка') + ' 2' },
                                sitelink3: { text: iget2('i-utils', 'bystraya-ssylka', 'быстрая ссылка') + ' 3' },
                                sitelink4: { text: iget2('i-utils', 'bystraya-ssylka', 'быстрая ссылка') + ' 4' },
                                undefined: { text: iget2('i-utils', 'ne-opredeleno', 'не определено') },
                                dialog: { text: iget2('i-utils', 'chat', 'чат') },
                                turbo_gallery: { text: iget2('i-utils', 'turbo-gallery', 'турбо-галерея') },
                                phone: { text: iget2('i-utils', 'phone', 'телефон') },
                                adv_gallery: { text: iget2('i-utils', 'product-extensions', 'товарные дополнения') },
                                market: { text: iget2('i-utils', 'market', 'маркет') },
                                promo_extension: { text: iget2('i-utils', 'promo-extension', 'промоакция') }
                            }
                        },
                        banner_image_type: {
                            text: iget2('i-utils', 'formaty', 'Форматы'),
                            children: {
                                text_only: { text: iget2('i-utils', 'tekstovyy', 'Текстовый') },
                                text_image: { text: iget2('i-utils', 's-izobrazheniem', 'С изображением') },
                                text_video: { text: iget2('i-utils', 's-video', 'С видео') },
                                smart_creative: { text: iget2('i-utils', 'smart_creative', 'Смарт-креатив') },
                                smart_tgo: { text: iget2('i-utils', 'smart_tgo', 'Смарт-объявление') },
                                smart_tile: { text: iget2('i-utils', 'smart_tile', 'Смарт-плитка') },
                                smart_video: { text: iget2('i-utils', 'smart_video', 'Смарт-видео') },
                                multicard: { text: iget2('i-utils', 'multicard-v2', 'Карусель') }
                            }
                        },
                        image_size: {
                            text: iget2('i-utils', 'razmer-izobrazheniya', 'Размер изображения'),
                            children: {
                                with_image: { text: iget2('i-utils', 's-izobrazheniem-186', 'с изображением') },
                                no_image: { text: iget2('i-utils', 'bez-izobrazheniya', 'без изображения') }
                            }
                        },
                        turbo_page_type: {
                            text: iget2('i-utils', 'turbo_page_type-2', 'Турбо-версия площадки'),
                            children: {
                                turbo: { text: iget2('i-utils', 'turbo_page_type_turbo', 'турбо') },
                                none: { text: iget2('i-utils', 'turbo_page_type_none', 'прочее') }
                            }
                        },
                        device_type: {
                            text: iget2('i-utils', 'tip-ustroystva', 'Тип устройства'),
                            children: {
                                mobile: { text: iget2('i-utils', 'mobilnye', 'Мобильные') },
                                tablet: { text: iget2('i-utils', 'planshety', 'Планшеты') },
                                desktop: { text: iget2('i-utils', 'desktop', 'Десктоп') }
                            }
                        },
                        detailed_device_type: {
                            text: iget2('i-utils', 'tip-operacionnoy-sistemy', 'Тип операционной системы'),
                            children: {
                                android: { text: iget2('i-utils', 'android', 'Android') },
                                ios: { text: iget2('i-utils', 'ios', 'iOS') },
                                other: { text: iget2('i-utils', 'ne-opredelen', 'Не определен') }
                            }
                        },
                        connection_type: {
                            text: iget2('i-utils', 'tip-svyazi', 'Тип связи'),
                            children: {
                                mobile: { text: iget2('i-utils', 'mobilnaya-svyaz', 'Мобильная связь') },
                                stationary: { text: iget2('i-utils', 'wi-fi', 'Wi-Fi') }
                            }
                        },
                        deal: {
                            text: iget2('i-utils', 'sdelki', 'Сделки'),
                            children: {
                                0: { text: iget2('i-utils', 'without-deal', 'Без сделки') }
                            }
                        },
                        aprgoodmultigoal: { text: placePostClick(iget2('i-utils', 'uroven-vovlechennosti', 'Уровень вовлеченности')) },
                        pv_aprgoodmultigoal: { text: placePostView(iget2('i-utils', 'uroven-vovlechennosti', 'Уровень вовлеченности')) },
                        aprgoodmultigoal_cpa: { text: function(params) { return placePostClick(iget2('i-utils', 'tsena-vovlechenia', 'Цена вовлечения ({currency})', params)); } },
                        pv_aprgoodmultigoal_cpa: { text: function(params) { return placePostView(iget2('i-utils', 'tsena-vovlechenia', 'Цена вовлечения ({currency})', params)); } },
                        aprgoodmultigoal_conv_rate: { text: placePostClick(iget2('i-utils', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)')) },
                        pv_aprgoodmultigoal_conv_rate: { text: placePostView(iget2('i-utils', 'koefficient-vovlechennosti', 'Коэффициент вовлеченности (%)')) },
                        avg_bid: { text: function(params) { return iget2('i-utils', 'srednia-stavka-za-klik', 'Ср. ставка за клик ({currency})', params); } },
                        uniq_viewers: { text: iget2('i-utils', 'ohvat', 'Охват') },
                        avg_view_freq: { text: iget2('i-utils', 'sr-chastota-pokazov', 'Ср. частота показов') },
                        auction_wins: { text: iget2('i-utils', 'auction-wins2', 'Выигрыши в аукционах') },
                        auction_hits: { text: iget2('i-utils', 'auction-hits', 'Участие в аукционах') },
                        imp_reach_rate: { text: iget2('i-utils', 'imp-reach-rate', 'SOV (%)') },
                        auction_win_rate: { text: iget2('i-utils', 'auction-win-rate2', 'Доля выигрышей (%)') },
                        served_impressions: { text: iget2('i-utils', 'served_impressions', 'Выходы') },
                        uniq_completed_viewers: { text: iget2('i-utils', 'uniq-completed-viewers', 'Достроенный охват') },
                        video_first_quartile: { text: iget2('i-utils', 'clip-first-quartile', 'Проигрывание 25% ролика') },
                        video_first_quartile_rate: { text: iget2('i-utils', 'clip-first-quartile-rate', 'Доля проигрываний 25% ролика') },
                        video_midpoint: { text: iget2('i-utils', 'clip-midpoint', 'Проигрывание 50% ролика') },
                        video_midpoint_rate: { text: iget2('i-utils', 'clip-midpoint-rate', 'Доля проигрываний 50% ролика') },
                        video_third_quartile: { text: iget2('i-utils', 'clip-third-quartile', 'Проигрывание 75% ролика') },
                        video_third_quartile_rate: { text: iget2('i-utils', 'clip-third-quartile-rate', 'Доля проигрываний 75% ролика') },
                        video_complete: { text: iget2('i-utils', 'clip-complete', 'Проигрывание 100% ролика') },
                        video_complete_rate: { text: iget2('i-utils', 'clip-complete-rate', 'Доля проигрываний 100% ролика') },
                        avg_nshow_complete: { text: iget2('i-utils', 'avg-nshow-complete', 'Заметность досмотров (%)') },
                        video_true_view: { text: iget2('i-utils', 'clip-true-view', 'Просмотры') },
                        video_avg_true_view_cost: { text: function(params) { return iget2('i-utils', 'clip-avg-true-view-cost', 'Ср. цена просмотра ролика ({currency})', params); } },
                        video_true_view_rate: { text: iget2('i-utils', 'clip-true-view-rate', 'Доля просмотров (%)') },
                        video_mute: { text: iget2('i-utils', 'video-mute', 'Клики выключить звук') },
                        video_unmute: { text: iget2('i-utils', 'video-unmute', 'Клики включить звук') },
                        cpcv: {
                            text: function(params) {
                                return iget2('i-utils', 'cpcc-completed-view', 'Ср. цена досмотра 100% ролика ({currency})', params);
                            }
                        },
                        inventory_type: {
                            text: iget2('i-utils', 'inventory-type', 'Тип инвентаря'),
                            children: {
                                inpage: { text: iget2('i-utils', 'inpage', 'Текстовый контент') },
                                instream_web: { text: iget2('i-utils', 'instream-web', 'Потоковое видео') },
                                interstitial: { text: iget2('i-utils', 'interstitial', 'Приложения') },
                                inbanner: { text: iget2('i-utils', 'inbanner', 'Видео в баннере') },
                                rewarded: { text: iget2('i-utils', 'rewarded', 'Видео за вознаграждение') }
                            }
                        },
                        viewable_impressions_mrc: { text: iget2('i-utils', 'viewable-impressions-mrc', 'Видимые показы, стандарт MRC') },
                        nonviewable_impressions_mrc: { text: iget2('i-utils', 'nonviewable-impressions-mrc', 'Невидимые показы, стандарт MRC') },
                        undetermined_impressions_mrc: { text: iget2('i-utils', 'undetermined-impressions-mrc', 'Неустановленные показы, стандарт MRC') },
                        measured_rate_mrc: { text: iget2('i-utils', 'measured-rate-mrc', 'Доля измеряемых показов, стандарт MRC (%)') },
                        viewable_rate_mrc: { text: iget2('i-utils', 'viewable-rate-mrc', 'Доля видимых показов, стандарт MRC (%)') },
                        content_targeting: {
                            text: iget2('i-utils', 'content-targeting', 'Жанры и тематики')
                        }
                    }
                },
                dayBudget: {
                    children: {
                        mode: {
                            text: iget2('i-utils', 'rezhim-pokaza', 'режим показа'),
                            children: {
                                default: { text: iget2('i-utils', 'standartnyy', 'стандартный') },
                                stretched: { text: iget2('i-utils', 'raspredelyonnyy', 'распределённый') }
                            }
                        }
                    }
                },
                'p-multiedit2': {
                    children: {
                        groups: {
                            children: {
                                banners: {
                                    children: {
                                        'BannerDefectIds.Gen.REQUIRED_HREF_OR_VCARD_ID': {
                                            text: iget2(
                                                'i-utils',
                                                'banners-required-href-or-vcard-id2',
                                                'В объявлении должна быть указана или визитка или основная ссылка'
                                            )
                                        },
                                        'BannerDefectIds.LanguageDefect.INCONSISTENT_LANGUAGE_WITH_GEO': {
                                            text: function(params) {
                                                switch (params.backendParams) {
                                                    case 'KAZAKH':
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-kazakh',
                                                            'Текст объявления написан на казахском языке и не соответствует установленному региону показа. Возможен таргетинг только на Казахстан.'
                                                        );
                                                    case 'UKRAINE':
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-ukraine',
                                                            'Текст объявления написан на украинском языке и не соответствует установленному региону показа. Возможен таргетинг только на Украину.'
                                                        );
                                                    case 'TURKISH':
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-turkish',
                                                            'Текст объявления написан на турецком языке и не соответствует установленному региону показа. Возможен таргетинг только на Турцию.'
                                                        );
                                                    case 'BELARUSIAN':
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-belarusian',
                                                            'Текст объявления написан на белорусском языке и не соответствует установленному региону показа. Возможен таргетинг только на Беларусь.'
                                                        );
                                                    case 'UZBEK':
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-uzbek',
                                                            'Текст объявления написан на узбекском языке и не соответствует установленному региону показа. Возможен таргетинг только на Узбекистан.'
                                                        );
                                                    default:
                                                        return iget2(
                                                            'i-utils',
                                                            'banners-text-language-inconsistent-with-geo-default',
                                                             'Текст объявления не соотвествует установленому региону.'
                                                        );
                                                }
                                            }
                                        },
                                        title: {
                                            children: u._.extend(
                                                {
                                                    'BannerDefectIds.String.SHOULD_NOT_BE_BLANK': SUPPORTING_STORE.banner.shouldNotBeBlank
                                                },
                                                SUPPORTING_STORE.banner.adTextFields
                                            )
                                        },
                                        title_extension: {
                                            children: SUPPORTING_STORE.banner.adTextFields
                                        },
                                        description: {
                                            children: SUPPORTING_STORE.banner.adTextFields
                                        },
                                        body: {
                                            children: u._.extend(
                                                {
                                                    'BannerDefectIds.String.SHOULD_NOT_BE_BLANK': SUPPORTING_STORE.banner.shouldNotBeBlank
                                                },
                                                SUPPORTING_STORE.banner.adTextFields
                                            )
                                        },
                                        href: {
                                            children: {
                                                'BannerDefectIds.Gen.INVALID_DOMAIN': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'banner-href-invalid-domain',
                                                        'Некорректный домен'
                                                    )
                                                }
                                            }
                                        },
                                        display_href: {
                                            children: {
                                                'BannerDefectIds.String.DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'display-href-display-href-length-cannot-be-more-than-max',
                                                            'Отображаемая ссылка не может быть длиннее {maxLength} символов',
                                                            { maxLength: params.backendParams.maxLength }
                                                        );
                                                    }
                                                },
                                                'BannerDefectIds.Gen.INVALID_DISPLAY_HREF_USAGE': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'display-href-invalid-display-href-usage',
                                                        'Задана отображаемая ссылка, но не указана основная ссылка в объявлении'
                                                    )
                                                }
                                            }
                                        },
                                        pixels: {
                                            children: {
                                                'BannerDefectIds.Gen.INVALID_PIXEL_FORMAT': {
                                                    text: function(params) {
                                                        switch (params.value.kind) {
                                                            case 'audience':
                                                                return iget2(
                                                                    'i-utils',
                                                                    'pixels-provider-is-prohibited',
                                                                    'Введенный вами код не соответствует формату кода пикселя Яндекс.Аудиторий. Для получения кода пикселя воспользуйтесь сервисом Яндекс Аудитории'
                                                                );
                                                            case 'audit':
                                                                return iget2(
                                                                    'i-utils',
                                                                    'pixels-audit-invalid-pixel-format',
                                                                    'Введенный вами код не соответствует формату допустимых счетчиков.'
                                                                );
                                                            default:
                                                                return iget2(
                                                                    'i-utils',
                                                                    'bad-pixel',
                                                                    'Введенный вами код не соответствует формату'
                                                                );
                                                        }
                                                    }
                                                },
                                                'BannerDefectIds.PixelProviderLimits.EQUAL_PIXEL_PROVIDERS': {
                                                    text: function(params) {
                                                        var backendParams = params.backendParams,
                                                            providerNames = backendParams
                                                                .exceededClientPixelProviderNamesJoined;

                                                        return iget2(
                                                            'i-utils',
                                                            'pixels-audit-equal-providers',
                                                            'Счётчики показов следующих провайдеров указаны более одного раза: {providerNames}.', {
                                                                providerNames: providerNames,
                                                                context: 'providerNames - перечисление названий счетчиков'
                                                            }
                                                        );
                                                    }
                                                },
                                                'BannerDefectIds.String.NO_RIGHTS_TO_AUDIENCE_PIXEL': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'pixels-no-rights-to-audience-pixel',
                                                        'Пиксель Яндекс.Аудиторий не поддерживается'
                                                    )
                                                },
                                                'BannerDefectIds.PixelPermissions.NO_RIGHTS_TO_PIXEL': {
                                                    text: function(params) {
                                                        var backendParams = params.backendParams,
                                                            counters = backendParams.accessibleClientProviderNames,
                                                            countersText = counters[0];

                                                        return iget2(
                                                            'i-utils',
                                                            'pixels-audit-provider-is-prohibited-use-counters',
                                                            'Неправильный формат счетчика. Для сбора статистики вы можете использовать счетчик {providerNames}. Ссылка должна содержать макрос %random%.', {
                                                                providerNames: function(text) {
                                                                    if (counters.length > 1) {
                                                                        countersText = counters.slice(0, -1).join(', ') +
                                                                            ' ' + text + ' ' + counters.slice(-1);
                                                                    }

                                                                    return countersText;
                                                                }(iget2(
                                                                    'i-utils',
                                                                    'pixels-audit-provider-is-prohibited-use-counters-or',
                                                                    'или'
                                                                )),

                                                                context: 'providerNames - перечисление. 1 | 1 или 2 | 1, 2 или 3'
                                                            }
                                                        );
                                                    }
                                                },
                                                'BannerDefectIds.PixelWithMeasurer.INVALID_PIXEL_WITH_MEASURER': {
                                                    text: function(params) {
                                                        var backendParams = params.backendParams,
                                                            measurerSystemName = backendParams.measurerSystemName || '',
                                                            pixelUrl = backendParams.pixelUrl || '';

                                                        return iget2(
                                                            'i-utils',
                                                            'invalid-pixel-with-measurer',
                                                            'Невозможно одновременно использовать пиксель {pixel} и внешний измеритель {measurer}. Удалите одно из значений',
                                                            {
                                                                measurer: u.measurers.getMeasurerSystemName(
                                                                    measurerSystemName.toLowerCase()
                                                                ),
                                                                pixel: u.parseUrl(pixelUrl).host
                                                            }
                                                        );
                                                    }
                                                }
                                            }
                                        },
                                        banner_price: {
                                            children: {
                                                'BannerDefectIds.Gen.BANNER_PRICE_GREATER_THAN_OLD': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'price-cannot-be-less-than-priceOld',
                                                        'Цена должна быть меньше старой цены'
                                                    )
                                                },
                                                price: {
                                                    children: {
                                                        'NumberDefectIds.MUST_BE_GREATER_THAN_MIN': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'price-cannot-be-less-than-min',
                                                                'Цена не может быть отрицательной'
                                                            )
                                                        },
                                                        'NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'price-cannot-be-more-than-max',
                                                                'Цена больше максимально допустимого значения'
                                                            )
                                                        },
                                                    }
                                                },
                                                priceOld: {
                                                    children: {
                                                        'NumberDefectIds.MUST_BE_GREATER_THAN_MIN': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'priceOld-cannot-be-less-than-min',
                                                                'Старая цена не может быть отрицательной'
                                                            )
                                                        },
                                                        'NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'priceOld-cannot-be-more-than-max',
                                                                'Старая цена больше максимально допустимого значения'
                                                            )
                                                        },
                                                    }
                                                }
                                            }
                                        },
                                        turbolanding_href_params: {
                                            children: {
                                                'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                    text: function(params) {
                                                        return u.pluralForms(
                                                            iget2(
                                                                'i-utils',
                                                                'turbolanding-href-params-length-cannot-be-more-than-max',
                                                                'Превышена максимальная длина строки параметров ссылки, {maxLength} {символ|символа|символов}.',
                                                                { maxLength: params.backendParams.maxLength }
                                                            ),
                                                            params.backendParams.maxLength
                                                        )
                                                    }
                                                }
                                            }
                                        },
                                        sitelinks: {
                                            children: {
                                                'SitelinkDefectIds.Strings.MAX_SITELINKS_TITLES_LENGTH': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'sitelinks-title-max-sitelinks-titles-length',
                                                            'Превышена суммарная длина текста быстрых ссылок — максимум {maxLength} символов',
                                                            { maxLength: params.backendParams.maxLength }
                                                        );
                                                    }
                                                },
                                                title: {
                                                    children: {
                                                        'SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_TITLE': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'sitelinks-title-allowed-symbols-sitelink-title',
                                                                'В тексте быстрых ссылок можно использовать только буквы латинского, турецкого, русского, украинского, казахского или белорусского алфавита, знаки пунктуации, за исключением !,?'
                                                            )
                                                        }
                                                    }
                                                },
                                                href: {
                                                    children: {
                                                        'SitelinkDefectIds.Strings.SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params) {
                                                                return iget2(
                                                                    'i-utils',
                                                                    'sitelinks-href-length-cannot-be-more-than-max',
                                                                    'Максимальная длина ({maxLength}) ссылки превышена',
                                                                    { maxLength: params.backendParams.maxLength }
                                                                );
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        vcard: {
                                            children: {
                                                country: {
                                                    text: iget2('i-utils', 'vcard-country', 'Страна'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                city: {
                                                    text: iget2('i-utils', 'vcard-city', 'Город'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                house: {
                                                    text: iget2('i-utils', 'vcard-house', 'Дом'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                build: {
                                                    text: iget2('i-utils', 'vcard-build', 'Корпус'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                name: {
                                                    text: iget2('i-utils', 'vcard-name-fio', 'Название компании/ФИО'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                contactperson: {
                                                    text: iget2('i-utils', 'vcard-contactperson', 'Контактное лицо'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                extra_message: {
                                                    text: iget2('i-utils', 'vcard-extra-message', 'Подробнее о товаре/услуге'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                street: {
                                                    text: iget2('i-utils', 'vcard-street', 'Улица'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                apart: {
                                                    text: iget2('i-utils', 'vcard-apart', 'Офис'),
                                                    children: {
                                                        'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS
                                                                    .text({
                                                                        fieldName: u._.get(
                                                                            store,
                                                                            path.slice(0, -2).concat('text')
                                                                        )
                                                                    });
                                                            }
                                                        },
                                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                            text: function(params, path, store) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        {
                                                                            fieldName: u._.get(
                                                                                store,
                                                                                path.slice(0, -2).concat('text')
                                                                            )
                                                                        },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                country_code: {
                                                    children: {
                                                        'PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_LONG': {
                                                            text: SUPPORTING_STORE.banner.vcard.COUNTRY_CODE_RULES.text
                                                        },
                                                        'PhoneValidator.VoidDefectIds.COUNTRY_CODE_MUST_START_WITH_PLUS': {
                                                            text: SUPPORTING_STORE.banner.vcard.COUNTRY_CODE_RULES.text
                                                        },
                                                        'PhoneValidator.VoidDefectIds.COUNTRY_CODE_FORMAT_IS_INVALID': {
                                                            text: SUPPORTING_STORE.banner.vcard.COUNTRY_CODE_RULES.text
                                                        }
                                                    }
                                                },
                                                city_code: {
                                                    children: {
                                                        'PhoneValidator.VoidDefectIds.CITY_CODE_FORMAT_IS_INVALID': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-city-code-format-is-invalid',
                                                                '«Код города» должен содержать от 1 до 5 символов, быть не равным 0 и состоять только из цифр'
                                                            )
                                                        },
                                                        'PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_LONG': {
                                                            text: function(params) {
                                                                return iget2(
                                                                    'i-utils',
                                                                    'vcard-city-code-is-too-long',
                                                                    'Поле «Код города» не может содержать больше {maxLength} цифр',
                                                                    { maxLength: params.backendParams.maxLength }
                                                                )
                                                            }
                                                        }
                                                    }
                                                },
                                                phone: {
                                                    children: {
                                                        'PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_SHORT': {
                                                            text: function(params) {
                                                                return iget2(
                                                                    'i-utils',
                                                                    'vcard-phone-number-is-too-short',
                                                                    'Поле «Телефон» не может содержать меньше {minLength} цифр',
                                                                    { minLength: params.backendParams.minLength }
                                                                )
                                                            }
                                                        },
                                                        'PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_LONG': {
                                                            text: function(params) {
                                                                return iget2(
                                                                    'i-utils',
                                                                    'vcard-phone-number-is-too-long',
                                                                    'Поле «Телефон» не может содержать больше {maxLength} цифр',
                                                                    { maxLength: params.backendParams.maxLength }
                                                                )
                                                            }
                                                        },
                                                        'PhoneValidator.VoidDefectIds.PHONE_NUMBER_FORMAT_IS_INVALID': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-phone-format-is-invalid',
                                                                'В поле «Телефон» указан неправильный формат номера телефона'
                                                            )
                                                        }
                                                    }
                                                },
                                                ext: {
                                                    children: {
                                                        'PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_LONG': {
                                                            text: function(params) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        { fieldName: iget2('i-utils', 'vcard-ext-phone', 'Добавочный номер') },
                                                                        params
                                                                    ));
                                                            }
                                                        },
                                                        'PhoneValidator.VoidDefectIds.EXTENSION_FORMAT_IS_INVALID': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-ext-phone-format-is-invalid',
                                                                'Добавочный номер должен содержать от 1 до 6 символов и состоять только из цифр'
                                                            )
                                                        }
                                                    }
                                                },
                                                contact_email: {
                                                    children: {
                                                        'AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_INVALID_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-contact-email-invalid-format',
                                                                'Значение в поле «E-mail» должно содержать только email-адрес'
                                                            )
                                                        },
                                                        'AddVcardValidationService.StringLengthDefectIds.CONTACT_EMAIL_TOO_LONG': {
                                                            text: function(params) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        { fieldName: iget2('i-utils', 'vcard-contact-email', 'E-mail') },
                                                                        params
                                                                    ));
                                                            }
                                                        }
                                                    }
                                                },
                                                im_client: {
                                                    children: {
                                                        'InstantMessengerValidator.VoidDefectIds.TYPE_IS_NULL': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-im-client-type-is-null',
                                                                'В поле «Интернет-пейджер» не указан тип интернет-пейджера'
                                                            )
                                                        }
                                                    }
                                                },
                                                im_login: {
                                                    children: {
                                                        'InstantMessengerValidator.StringDefectIds.LOGIN_IS_TOO_LONG': {
                                                            text: function(params) {
                                                                return SUPPORTING_STORE
                                                                    .banner
                                                                    .vcard
                                                                    .LENGTH_CANNOT_BE_MORE_THAN_MAX
                                                                    .text(u._.extend(
                                                                        { fieldName: iget2('i-utils', 'vcard-im-login', 'Интернет-пейджер') },
                                                                        params
                                                                    ));
                                                            }
                                                        },
                                                        'InstantMessengerValidator.VoidDefectIds.INVALID_ICQ_LOGIN_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-im-login-invalid-icq-login-format',
                                                                'ICQ UIN в поле «Интернет-пейджер» должен содержать от 5 до 10 цифр и состоять из цифр и дефисов'
                                                            )
                                                        },
                                                        'InstantMessengerValidator.VoidDefectIds.INVALID_JABBER_LOGIN_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-im-login-invalid-jabber-login-format',
                                                                'Jabber-идентификатор в поле «Интернет-пейджер» должен содержать только email-адрес'
                                                            )
                                                        },
                                                        'InstantMessengerValidator.VoidDefectIds.INVALID_MAIL_AGENT_LOGIN_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-im-login-invalid-mail-agent-login-format',
                                                                'Имя почтового ящика для Мail.Ru Агента в поле «Интернет-пейджер» должно содержать только email-адрес с доменами mail.ru, inbox.ru, bk.ru, list.ru'
                                                            )
                                                        },
                                                        'InstantMessengerValidator.VoidDefectIds.INVALID_SKYPE_OR_MSN_LOGIN_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-im-login-invalid-skype-or-msn-login-format',
                                                                'Skype-имя в поле «Интернет-пейджер» должно содержать email-адрес или имя, состоящее из букв, цифр и знаков пунктуации'
                                                            )
                                                        },
                                                        'InstantMessengerValidator.VoidDefectIds.LOGIN_IS_NULL': {
                                                            text: iget2('i-utils',
                                                                'vcard-im-login-empty-field',
                                                                'Не указано значение в поле «Интернет-пейджер»'
                                                            )
                                                        }
                                                    }
                                                },
                                                metro: {
                                                    children: {
                                                        'DefectIds.METRO_CITY_IS_REQUIRED': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-metro-city-is-required',
                                                                'В поле «Город» не указано значение, необходимое для определения станции метро'
                                                            )
                                                        },
                                                        'MetroIdValidator.DefectIds.INVALID_METRO': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'vcard-invalid-metro',
                                                                'В поле «Метро» указана станция, не существующая в выбранном городе'
                                                            )
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        creative: {
                                            children: {
                                                creative_id: {
                                                    children: {
                                                        'DefectIds.CANNOT_BE_NULL': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'neobhodimo-zagruzit-kreativ',
                                                                'Необходимо загрузить креатив'
                                                            )
                                                        },
                                                        'BannerDefectIds.Gen.INCOMPATIBLE_VIDEO_LAYOUT_ID': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'incompatible-video-layout-id',
                                                                'Выбранный креатив не подходит к типу объявления'
                                                            )
                                                        },
                                                        'BannerDefectIds.Gen.CPC_VIDEO_NOT_FOUND': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'cpc-video-not-found',
                                                                'Выбранный видео креатив не найден'
                                                            )
                                                        },
                                                        'CreativeDefectIds.AdminReject.CREATIVE_IS_ADMIN_REJECTED': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'creative-rulles-mismatch',
                                                                'Креатив не соответствует {requirement}',
                                                                {
                                                                    requirement: {
                                                                        block: 'link',
                                                                        url: u.formatUrl({
                                                                            host: u.url.getRegionalDomain(),
                                                                            path: '/support/direct/products-cpm-campaign-frontpage/requirements.html'
                                                                        }),
                                                                        content: iget2('i-utils', 'creative-specifications', 'техническим требованиям')
                                                                    }
                                                                }
                                                            )
                                                        },
                                                        'BannerDefectIds.Gen.INCONSISTENT_CREATIVE_FORMAT': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'creative-size-unsupported',
                                                                'Креативы данного размера не поддерживаются. Создайте новое объявление с креативом другого размера.'
                                                            )

                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        video_resources: {
                                            children: {
                                                id: {
                                                    children: {
                                                        'BannerDefectIds.Gen.INCOMPATIBLE_VIDEO_LAYOUT_ID': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'incompatible-video-addition-layout-id',
                                                                'Выбранный креатив не может быть использован в качестве видеодополнения'
                                                            )
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        tnsId: {
                                            children: {
                                                'BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD': {
                                                    text: function() {
                                                        return iget2(
                                                            'i-utils',
                                                            'tns-id-restricted-characters',
                                                            'В TNS ID можно использовать только буквы латинского алфавита и цифры'
                                                        );
                                                    }
                                                },
                                                'BannerDefectIds.Gen.NOT_EMPTY_TNSID_WITH_EMPTY_PIXELS': {
                                                    text: function() {
                                                        return iget2(
                                                            'i-utils',
                                                            'tns-id-empty-pixels',
                                                            'Нельзя указать TNS ID, не указав счётчик показов'
                                                        );
                                                    }
                                                },
                                                'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'tns-id-cannot-be-more-than-max',
                                                            'Значение поля не должно превышать {maxLength} символов',
                                                            {
                                                                maxLength: params.backendParams.maxLength
                                                            }
                                                        );
                                                    }
                                                },
                                                'StringDefectIds.CANNOT_BE_EMPTY': {
                                                    text: function() {
                                                        return iget2(
                                                            'i-utils',
                                                            'tns-id-cannot-be-empty',
                                                            'Поле не может быть пустым'
                                                        );
                                                    }
                                                }
                                            }
                                        },
                                        measurers: {
                                            children: {
                                                'DefectIds.INVALID_VALUE': {
                                                    text: function(params) {
                                                        var measurerSystemName = u.measurers.getMeasurerSystemName(
                                                            params.value.measurer_system
                                                        );

                                                        return [
                                                            iget2(
                                                                'i-utils',
                                                                'measurers-admetrica-params-invalid',
                                                                'Неверное значение параметра'
                                                            ),
                                                            measurerSystemName
                                                        ].filter(Boolean).join(': ');
                                                    }
                                                },
                                                'DefectIds.CANNOT_BE_NULL': {
                                                    text: function(params) {
                                                        var measurerSystemName = u.measurers.getMeasurerSystemName(
                                                            params.value.measurer_system
                                                        );

                                                        return [
                                                            iget2(
                                                                'i-utils',
                                                                'measurers-admetrica-params-invalid',
                                                                'Неверное значение параметра'
                                                            ),
                                                            measurerSystemName
                                                        ].filter(Boolean).join(': ');
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    content_resource: {
                                        children: {
                                            content_id: {
                                                children: {
                                                    'BannerDefectIds.Gen.CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE': {
                                                        text: iget2('i-utils', 'content-promotion-collection-inaccessible', 'Коллекция недоступна')
                                                    },
                                                    'BannerDefectIds.Gen.CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE': {
                                                        text: iget2('i-utils', 'content-promotion-video-inaccessible', 'Видео недоступно')
                                                    }
                                                }
                                            }
                                        }
                                    }
                                },
                                adgroup_id: {
                                    children: {
                                        'DefectIds.CANNOT_BE_NULL': {
                                            text: iget2('i-utils', 'adgroup-id-cannot-be-null', 'Отсутствует ID группы')
                                        },
                                        'DefectIds.OBJECT_NOT_FOUND': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'adgroup-id-object-not-found',
                                                    'Группа {id} не найдена',
                                                    { id: params.value }
                                                )
                                            }
                                        }
                                    }
                                },
                                cid: {
                                    children: {
                                        'DefectIds.CANNOT_BE_NULL': {
                                            text: iget2('i-utils', 'cid-id-cannot-be-null', 'Отсутствует ID кампании')
                                        }
                                    }
                                },
                                group_name: {
                                    children: {
                                        'AdGroupDefectIds.Gen.AD_GROUP_NAME_CANT_BE_EMPTY': {
                                            text: iget2(
                                                'i-utils',
                                                'ad-group-name-cant-be-empty',
                                                'Необходимо указать название группы'
                                            )
                                        },
                                        'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'length-cannot-be-more-than-max',
                                                    'Название группы не может быть длиннее {maxLength} символов',
                                                    { maxLength: params.backendParams.maxLength }
                                                );
                                            }
                                        }
                                    }
                                },
                                geo: {
                                    children: {
                                        'DefectIds.CANNOT_BE_NULL': {
                                            text: iget2('i-utils', 'geo-cannot-be-null', 'Необходимо выбрать регионы показа')
                                        },
                                        'RegionIdDefectIds.Gen.EMPTY_REGIONS': {
                                            text: iget2('i-utils', 'geo-empty-regions', 'Пустой регион')
                                        },
                                        'RegionIdDefectIds.Gen.NO_PLUS_REGIONS': {
                                            text: iget2('i-utils', 'geo-no-plus-regions', 'Отсутствуют плюс-регионы')
                                        },
                                        'RegionIdDefectIds.RegionIds.INCORRECT_REGIONS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'geo-ids-incorrect-regions',
                                                    'Указан несуществующий регион: {regionIds}',
                                                    { regionIds: params.value }
                                                );
                                            }
                                        },
                                        'RegionIdDefectIds.RegionIds.MINUS_REGION_MATCHES_PLUS_REGION': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'geo-minus-region-matches-plus-region',
                                                    'Неверный формат, минус-регион {minusRegionIds} не может вычитать плюс-регион {regionIds}',
                                                    {
                                                        minusRegionIds: params.backendParams.minusRegionIds,
                                                        regionIds: params.backendParams.regionIds
                                                    }
                                                );
                                            }
                                        },
                                        'RegionIdDefectIds.Regions.MINUS_REGIONS_WITHOUT_PLUS_REGIONS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'geo-minus-regions-without-plus-regions',
                                                    'Присутствуют минус-регионы, не содержащиеся ни в одном из плюс-регионов: {regionIds}',
                                                    { regionIds: params.value }
                                                );
                                            }
                                        } ,
                                        'AdGroupDefectIds.Geo.BAD_GEO': {
                                            text: function(params) {
                                                switch (params.backendParams.language) {
                                                    case 'KAZAKH':
                                                        return iget2(
                                                            'i-utils',
                                                            'ad-group-bad-geo-for-kazakh',
                                                            'Геотаргетинг не может быть изменён, так как текст объявления {bannerId} на казахском языке. Возможен таргетинг только на Казахстан.',
                                                            {
                                                                bannerId: params.backendParams.bannerId || ''
                                                            }
                                                        );
                                                    case 'UKRAINE':
                                                        return iget2(
                                                            'i-utils',
                                                            'ad-group-bad-geo-for-ukraine',
                                                            'Геотаргетинг не может быть изменён, так как текст объявления {bannerId} на украинском языке. Возможен таргетинг только на Украину.',
                                                            {
                                                                bannerId: params.backendParams.bannerId || ''
                                                            }
                                                        );
                                                    case 'TURKISH':
                                                        return iget2(
                                                            'i-utils',
                                                            'ad-group-bad-geo-for-turkish',
                                                            'Геотаргетинг не может быть изменён, так как текст объявления {bannerId} на турецком языке. Возможен таргетинг только на Турцию.',
                                                            {
                                                                bannerId: params.backendParams.bannerId || ''
                                                            }
                                                        );
                                                    case 'BELARUSIAN':
                                                        return iget2(
                                                            'i-utils',
                                                            'ad-group-bad-geo-for-belarusian',
                                                            'Геотаргетинг не может быть изменён, так как текст объявления {bannerId} на белорусском языке. Возможен таргетинг только на Беларусь.',
                                                            {
                                                                bannerId: params.backendParams.bannerId || ''
                                                            }
                                                        );
                                                    default:
                                                        return iget2(
                                                            'i-utils',
                                                            'ad-group-bad-geo-for-default',
                                                            'Текст объявления {bannerId} не соответствует установленому региону.',
                                                            {
                                                                bannerId: params.backendParams.bannerId || ''
                                                            }
                                                        );
                                                }
                                            }
                                        }
                                    }
                                },
                                minus_words: {
                                    children: {
                                        'DefectIds.CANNOT_BE_NULL': {
                                            text: iget2(
                                                'i-utils',
                                                'minus-words-cannot-be-null',
                                                'Минус-фразы на группу не могут содержать пустые значения'
                                            )
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.SEPARATE_DOT': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-separate-dot',
                                                    'Минус-фразы не могут содержать отдельно стоящие точки: {minusWords}',
                                                    {
                                                        minusWords: params.value
                                                    }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.WRONG_QUOTES': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-wrong-quotes',
                                                    'Неправильное использование кавычек в минус-фразах: {minusWords}',
                                                    {
                                                        minusWords: params.value
                                                    }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.IndividualKeywordLength.MAX_LENGTH_MINUS_WORD': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-max-length-minus-word',
                                                    'Превышена допустимая длина слова в минус-фразе в {maxLength} символов. Ошибки во фразах: {minusWords}',
                                                    {
                                                        minusWords: params.backendParams.subset.join(', '),
                                                        maxLength: params.backendParams.maxLength
                                                    }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.IndividualKeywordLength.MAX_COUNT_WORDS_IN_KEYWORD': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-max-count-words-in-keyword',
                                                    'Минус-фраза не может состоять более чем из {maxWords} слов: {minusWords}',
                                                    {
                                                        minusWords: params.backendParams.subset.join(', '),
                                                        maxWords: params.backendParams.maxWords
                                                    }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.IMBALANCED_SQUARE_BRACKETS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-imbalanced-square-brackets',
                                                    'Неправильное использование скобок «[» «]» в минус-фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.NESTED_OR_EMPTY_SQUARE_BRACKETS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-nested-or-empty-square-brackets',
                                                    'Квадратные скобки «[» «]» не могут быть пустыми и вложенными, минус-фразы: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_OPERATORS_INSIDE_SQUARE_BRACKETS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-operators-inside-square-brackets',
                                                    'Внутри скобок [] недопустимы символы +-"", минус-фразы: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_EXCLAMATION_MARK': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-exclamation-mark',
                                                    'Неправильное использование знака «!» в минус-фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_MINUS_MARK': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-minus-mark',
                                                    'Неправильное использование знака «-» в минус-фразах: {minusWords}\nЗнак «-» нельзя использовать в начале и в конце слов',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_PLUS_MARK': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-plus-mark',
                                                    'Неправильное использование знака «+» в минус-фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_WORD_FIRST_CHARACTER': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-word-first-character',
                                                    'Неправильное сочетание специальных символов в минус-фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.INVALID_DOT': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-invalid-dot',
                                                    'Минус-фразы могут содержать не более двух цифр подряд через точку. Ошибки во фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        },
                                        'MinusPhraseDefectIds.MinusPhrase.ILLEGAL_MINUS_KEYWORD_CHARS': {
                                            text: function(params) {
                                                return iget2(
                                                    'i-utils',
                                                    'minus-phrase-illegal-minus-keyword-chars',
                                                    'В минус-фразах разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, квадратные скобки, знаки «-», «+», «!», пробел.\nОшибки во фразах: {minusWords}',
                                                    { minusWords: params.backendParams.subset.join(', ') }
                                                );
                                            }
                                        }
                                    }
                                },
                                keywords: {
                                    children: {
                                        phrase: {
                                            children: {
                                                'StringDefectIds.CANNOT_BE_EMPTY': {
                                                    text: iget2('i-utils', 'phrase-cannot-be-empty', 'Ключевая фраза не может быть пустой')
                                                },
                                                'PhraseDefectIds.String.TOO_LONG_WORD': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-too-long-word',
                                                            'Превышена допустимая длина отдельного ключевого слова в {maxLength} символов. Ошибки в словах: {word}',
                                                            {
                                                                word: params.backendParams.allInvalidSubstrings,
                                                                maxLength: params.backendParams.maxLength
                                                            }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.String.TOO_MANY_WORDS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-too-many-words',
                                                            'Ключевая фраза не может состоять более чем из {maxWords} слов. Ошибки во фразе: {phrase}',
                                                            {
                                                                phrase: u.escapeHTML(params.value),
                                                                maxWords: params.backendParams.maxWords
                                                            }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.String.TOO_LONG_KEYWORD': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-too-long-keyword',
                                                            'Превышена допустимая длина строки в {maxLength} символов в ключевой фразе: {phrase}',
                                                            {
                                                                phrase: u.escapeHTML(params.value),
                                                                maxLength: params.backendParams.maxLength
                                                            }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.String.ILLEGAL_CHARACTERS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-illegal-characters',
                                                            'В тексте ключевых фраз разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, знаки «-», «+», «!», пробел. Ошибка в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_QUOTES': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-quotes',
                                                            'Неправильное использование кавычек в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_BRACKETS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-brackets',
                                                            'Неправильное использование скобок [] в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INCORRECT_USE_OF_PARENTHESIS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-incorrect-use-of-parenthesis',
                                                            'Ошибка в использовании оператора, возможно, использованы непарные скобки в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_EXCLAMATION_MARK': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-exclamation-mark',
                                                            'Неправильное использование знака «!» в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_PLUS_MARK': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-plus-mark',
                                                            'Неправильное использование знака «+» в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_MINUS_MARK': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-minus-mark',
                                                            'Неправильное использование знака «-» в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_POINT': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-point',
                                                            'Неправильное сочетание специальных символов в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.INVALID_APOSTROPHE': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-invalid-apostrophe',
                                                            'Неправильное использование знака «\'» в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.MINUS_WORD_INSIDE_BRACKETS_OR_QUOTES': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-minus-word-inside-brackets-or-quotes',
                                                            'Минус-слова не могут быть в кавычках или квадратных скобках. Ошибка в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.PLUS_MARK_IN_BRACKETS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-plus-mark-in-brackets',
                                                            'Знак «+» не может использоваться в квадратных скобках. Ошибка в ключевой фразе: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.NO_PLUS_WORDS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-no-plus-words',
                                                            'Ключевая фраза не может состоять только из минус-слов: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.String.NOT_SINGLE_MINUS_WORD': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-not-single-minus-word',
                                                            'Из ключевой фразы могут вычитаться только отдельные слова, а не словосочетания: {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.String.MINUS_WORD_DELETE_PLUS_WORD': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-minus-word-delete-plus-word',
                                                            'Нельзя вычитать слово — ({word}), содержащееся в исходной ключевой фразе: {phrase}',
                                                            {
                                                                word: params.backendParams.allInvalidSubstrings,
                                                                phrase: u.escapeHTML(params.value)
                                                            }
                                                        );
                                                    }
                                                },
                                                'PhraseDefectIds.Gen.ONLY_STOP_WORDS': {
                                                    text: function(params) {
                                                        return iget2(
                                                            'i-utils',
                                                            'phrase-only-stop-words',
                                                            'Ключевая фраза не может состоять только из стоп-слов(союзов, предлогов, частиц): {phrase}',
                                                            { phrase: u.escapeHTML(params.value) }
                                                        );
                                                    }
                                                }
                                            }
                                        }
                                    }
                                },
                                targetInterests: {
                                    children: {
                                        condition_name: {
                                            children: {
                                                'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-name-already-exists',
                                                        'Условие показа с таким названием уже существует.'
                                                    )
                                                },
                                                'StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-name-only-letter',
                                                        'В названии условия допускается использование только букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и знаков пунктуации.'
                                                    )
                                                },
                                                'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-name-max-length',
                                                        'Длина названия не должна превышать 250 символов.'
                                                    )
                                                }
                                            }
                                        },
                                        groups: {
                                            children: {
                                                'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-groups-already-exists',
                                                        'Условие показа с таким набором правил уже существует.'
                                                    )
                                                },
                                                'CollectionDefectIds.INVALID_COLLECTION_SIZE': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-groups-limit',
                                                        'Превышен лимит целей.'
                                                    )
                                                }
                                            }
                                        },
                                        _all: {
                                            children: {
                                                'DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS': {
                                                    text: iget2(
                                                        'i-utils',
                                                        'target-interests-conditions-already-exists',
                                                        'Такое условие показа уже существует.'
                                                    )
                                                }
                                            }
                                        }
                                    }
                                },
                                pageBlocks: {
                                    children: {
                                        'CollectionDefectIds.Gen.CANNOT_BE_EMPTY': {
                                            text: iget2('i-utils', 'need-select-ad-platforms', 'Необходимо указать рекламные поверхности')
                                        }
                                    }
                                },
                                hierarchical_multipliers: {
                                    children: {
                                        retargeting_multiplier: {
                                            children: {
                                                conditions: {
                                                    children: {
                                                        'BidModifiersDefectIds.Number.TOO_MANY_RETARGETING_CONDITIONS': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'hierarchical-multipliers-conditions-too-many-retargeting-conditions',
                                                                'Превышено максимальное число условий «Ретаргетинг и аудитории»'
                                                            )
                                                        },
                                                        'RetargetingDefectIds.IdParametrized.RETARGETING_CONDITION_NOT_FOUND_WITH_ID': {
                                                            text: function(params) {
                                                                return iget2(
                                                                    'i-utils',
                                                                    'hierarchical-multipliers-conditions-retargeting-condition-not-found',
                                                                    'Несуществующее условие ретаргетинга {id}',
                                                                    { id: params.backendParams.id }
                                                                );
                                                            }
                                                        },
                                                        // eslint-disable-next-line max-len
                                                        multiplier_pct: SUPPORTING_STORE.hierarchicalMultipliers.multiplierPct
                                                    }
                                                }
                                            }
                                        },
                                        demography_multiplier: {
                                            children: {
                                                conditions: {
                                                    children: {
                                                        'BidModifiersDefectIds.Number.TOO_MANY_DEMOGRAPHY_CONDITIONS': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'hierarchical-multipliers-conditions-demography-too-many-conditions',
                                                                'Превышено максимальное число условий «Пол и возраст пользователя»'
                                                            )
                                                        },
                                                        'BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'hierarchical-multipliers-conditions-demography-required-at-least-one-of-age-or-gender',
                                                                'В условии отсутствует пол или возраст'
                                                            )
                                                        },
                                                        'BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION': {
                                                            text: iget2(
                                                                'i-utils',
                                                                'hierarchical-multipliers-conditions-demography-demographics-conditions-intersection',
                                                                'Пересекаются условия «Пол и возраст пользователя». Удалите одно из них или измените настройки'
                                                            )
                                                        },
                                                        // eslint-disable-next-line max-len
                                                        multiplier_pct: SUPPORTING_STORE.hierarchicalMultipliers.multiplierPct
                                                    }
                                                }
                                            }
                                        },
                                        mobile_multiplier: {
                                            children: {
                                                multiplier_pct: SUPPORTING_STORE.hierarchicalMultipliers.multiplierPct
                                            }
                                        },
                                        video_multiplier: {
                                            children: {
                                                multiplier_pct: SUPPORTING_STORE.hierarchicalMultipliers.multiplierPct
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                'cpm-yndx-frontpage': {
                    children: {
                        'BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_GREATER_THAN_MIN': {
                            text: function(params) {
                                return iget2(
                                    'i-utils',
                                    'cpm-price-is-not-greater-than-min-at',
                                    'Ставка не может быть меньше: {price}',
                                    { price: params.priceText }
                                );
                            }
                        },
                        'RegionIdDefectIds.Regions.GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE': {
                            text: function(params) {
                                var backendRegions = u._.get(params, 'backendParams.regions', []),
                                    regions = backendRegions.map(function(r) {
                                        return r.nameRu;
                                    }).join(', ');

                                return iget2(
                                    'i-utils',
                                    'price-not-match-for-shows-at-desktop-for-regions',
                                    'Недостаточная ставка для показа на полной версии Главной страницы в регионах: {regions}',
                                    { regions: regions }
                                );
                            }
                        },
                        'RegionIdDefectIds.Regions.GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE': {
                            text: function(params) {
                                var backendRegions = u._.get(params, 'backendParams.regions', []),
                                    regions = backendRegions.map(function(r) {
                                        return r.nameRu;
                                    }).join(', ');

                                return iget2(
                                    'i-utils',
                                    'price-not-match-for-shows-at-mobile-for-regions',
                                    'Недостаточная ставка для показа на мобильной версии Главной страницы в регионах: {regions}',
                                    { regions: regions }
                                );
                            }
                        },
                        'RegionIdDefectIds.Regions.GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE': {
                            text: function(params) {
                                var backendRegions = u._.get(params, 'backendParams.regions', []),
                                    regions = backendRegions.map(function(r) {
                                        return r.nameRu;
                                    }).join(', ');

                                return iget2(
                                    'i-utils',
                                    'price-not-match-for-shows-at-new-tab-for-regions',
                                    'Недостаточная ставка для показа на новой вкладке Браузера в регионах: {regions}',
                                    { regions: regions }
                                );
                            }
                        }
                    }
                }
            };

        return STORE
    };

    u.register(
        {

            placePostView: placePostView,
            placePostClick: placePostClick,

            'text-store': {

                /**
                 * Из переданных arguments строит путь к элементу из STORE и возвращает текст(если элемент существует)
                 * @param {...(Object|String)} args, первый аргумент может быть объектом - дополнительные парамерты
                 *     (например можно прокинуть валютут валюту)
                 * @returns {String}
                 */
                get: function(args) {
                    var path,
                        params,
                        item,
                        STORE = initStore();

                    if (typeof arguments[0] === 'object') {
                        params = arguments[0];
                        path = u.spacer2([].slice.call(arguments, 1), 'children');
                    } else {
                        path = u.spacer2([].slice.call(arguments), 'children');
                    }

                    if (item = u._.get(STORE, path)) {
                        return typeof item.text === 'function' ? item.text(params || {}, path, STORE) : item.text;
                    } else {
                        // если ничего не нашли возвращаетм последний аргумент
                        return u._.last(arguments);
                    }
                }

            }

        }
    );

}());
