(function() {

    function isTrafficVolumeApplicable(campType) {
        // return !u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'performance', 'dynamic'], campType);
        return true;
    }

    u.register({
        'traffic-volume': {

            /**
             * Условие отображения колонок для новых торгов в старой статистике
             * @param {String} campType - тип кампании
             * @returns {Boolean}
             */
            showTrafficVolumeStatFields: function(campType) {
                // return isTrafficVolumeApplicable(campType);
                return false;
            },

            /**
             * Условие отображения колонок для новых торгов в МО
             * @param {String|String[]} campTypes - типы кампаний
             * @returns {Boolean}
             */
            showTrafficVolumeStatFieldsMO: function(campTypes) {
                campTypes = [].concat(campTypes || []);
                return !!campTypes.filter(isTrafficVolumeApplicable).length;
            },

            /**
             * Возвращает список ключей поля traffic_volume (объем трафика) отсортированных по убыванию значения
             * @param {Object} trafficVolume - таблица объемов трафика для фразы
             * @param {Boolean} [filterByVisibility] - фильтровать ключи по полю `show_in_table`
             * @returns {String[]}
             */
            getTrafficVolumeKeys: function(trafficVolume, filterByVisibility) {
                return Object.keys(trafficVolume || {})
                    .filter(function(key) { return !filterByVisibility || Boolean(trafficVolume[key].show_in_table); })
                    .sort(function(a, b) { return b - a; })
                    .map(String);
            },

            /**
             * Проверяем, есть ли в группе условия показа с торгами
             * @param {Object} group
             */
            hasTrafficVolume: function(group) {

                return u._.some(group.banners || [], function(banner) {
                    return u._.some(banner.phrases || [], function(phrase) {
                        return u['traffic-volume'].hasCurrentTrafficVolume(phrase.traffic_volume, phrase.price);
                    })
                })

            },

            /**
             * Проверяет, применима ли к условию показа логика про торги
             * @param {Object} trafficVolume - торги
             * @param {Number} price - текущая ставка
             * @returns {Boolean}
             */
            hasCurrentTrafficVolume: function(trafficVolume, price) {
                return !!trafficVolume && !!+price;
            },

            /**
             * Расчет текущего объема трафика
             * @param {Object} trafficVolume - торги
             * @param {Number} price - текущая ставка
             * @returns {*}
             */
            getCurrentTrafficVolume: function(trafficVolume, price) {
                var leftBorderValueIndex,
                    multiplier,
                    data,
                    left,
                    right;

                price = +price;

                if (!u['traffic-volume'].hasCurrentTrafficVolume(trafficVolume, price)) {
                    return undefined;
                }

                trafficVolume = trafficVolume || {};

                // преобразуем объект в массив и сортируем по x
                data = Object.keys(trafficVolume)
                    .map(function(key) {
                        return {
                            x: Number(key),
                            price: trafficVolume[key].bid_price / 1e6
                        };
                    })
                    .sort(function(a, b) {
                        return a.x - b.x;
                    });

                // ищем верхнюю и нижнюю границы
                leftBorderValueIndex = u._.findLastIndex(data, function(el, index, arr) {
                    return el.price <= price;
                });

                left = data[leftBorderValueIndex];

                if (left) {
                    right = data[leftBorderValueIndex + 1];

                    if (right) {
                        // вычисляем промежуточное значение х
                        multiplier = (price - left.price) / (right.price - left.price);

                        return {
                            x: left.x + (right.x - left.x) * multiplier,
                            minPrice: left.price,
                            price: price
                        };
                    } else {
                        return {
                            x: left.x,
                            minPrice: left.price,
                            price: price
                        };
                    }
                } else {
                    return undefined;
                }
            }
        }
    });

})();
