(function() {
    u.register({
        turbo: {
            isLinkTurbo: function(link) {
                return !!link.match(/^(www\.)?yandex\.(\w+)(\.tr)?\/turbo(\W|$)/);
            },

            /**
             * Нужно ли показывать в превью турбо-страницу
             * @param {String} groupType - тип группы
             * @param {'cpm_banner'|'cpm_video'|'cpm_audio'|'cpm_outdoor', 'cpm_geoproduct'} cpmBannersType - подтип cpm группы
             * @returns {Boolean}
             */
            isGroupTypeSupported: function(groupType, cpmBannersType) {
                if (groupType === 'cpm_banner') {
                    return ['cpm_banner', 'cpm_video', 'cpm_geoproduct'].includes(cpmBannersType);
                }

                return true;
            }
        }
    })

}());
