u.register({
    /*jshint -W044*/
    commonDomainRegExp: '((pp|ac|boom|msk|spb|nnov)\.ru|(net|org|com|int|edu)\.[a-z]{2})',
    // eslint-disable-next-line require-iget2
    domainRegExp: '(?:(?:[_a-zа-яёЄІЇєіїҐґ0-9][_a-zа-яёЄІЇєіїҐґ0-9-]*)\\.)+([a-z0-9а-яёЄІЇєіїҐґ]{2,15}|xn--[a-z0-9-]+)',

    /**
     * Выполняет аякс прозвон ссылки.
     * В случае ошибки вызывает callback с data
     *  {
     *      text: '..',
     *      url: '..',
     *      code: 0
     *  }
     *
     * В случае успешного прозвона с data
     *  {
     *      domain_redir_sign: '...',
     *      domain_redir: '...',
     *      domain: '...',
     *      url: '...',
     *      domain_sign: '...',
     *      code: 1
     *  }
     * @param {Object} params
     * @param {String} params.url ссылка
     * @param {Function} params.callback коллбэк по выполнению запроса
     * @param {Object} params.ctx контекст
     * @param {String} [params.protocol] ссылка
     * @param {Boolean} [params._getMarketRating] внутренний флаг говорящий о необходимости получения рейтинга магазина в маркете
     * @param {Boolean} [params._isTrackingHref] внутренний флаг говорящий о том что проверяемая ссылка трекинговая (для РМП)
     * @returns {Object} ajax объект аякс запроса
     */
    urlCheck: function(params) {
        var request = BEM.blocks['i-mass-request-factory'].getInstanceFor('ajaxCheckUrlMass'),
            url = $.trim(params.url),
            protocol = params.protocol || 'https://';

        request.get({
            url: url,
            url_protocol: protocol,
            calc_market_rating: params._getMarketRating && '1',
            is_tracking_href: params._isTrackingHref && '1'
        }, function(data) {
            params.callback.call(params.ctx, data);
        }, function() {
            params.callback.call(params.ctx, { error: true });
        });

        return request;
    },

    /**
     * Проверяет урл и возвращает рейтинг магазин в маркете, если по урлу находится интернет-магазин
     * @param {String} params.url ссылка
     * @param {Function} params.callback коллбэк по выполнению запроса
     * @param {Object} params.ctx контекст
     * @param {String} [params.protocol] ссылка
     * @returns {Object}
     */
    urlCheckAndGetMarketRating: function(params) {
        return u.urlCheck(u._.extend(params, { _getMarketRating: true }));
    },

    /**
     * Проверяет урл трекинговой ссылки на принадлежность к поддерживаемым нами трекеров
     * @param {String} params.url ссылка
     * @param {Function} params.callback коллбэк по выполнению запроса
     * @param {Object} params.ctx контекст
     * @param {String} [params.protocol] ссылка
     * @returns {Object}
     */
    urlCheckTracking: function(params) {
        return u.urlCheck(u._.extend(params, { _isTrackingHref: true }));
    },

    /**
     * Вытаскивает имя домена из ссылки
     * @param {string} url ссылка
     * @returns {string}
     */
    extractDomain: function(url) {
        return $.trim(url).replace(/http(s)?:\/\//, '').replace(/[\/\?].*/, '').replace(/\#.*/, '').replace(/\/$/, '');
    },

    /**
     * Возвращает Regexp для проверки ссылок
     * @returns {RegExp}
     */
    hrefRegExp: function() {
        return new RegExp('^\\s*(?:http(s)?:\/\/)?' + u.domainRegExp + '(?:\\s*$|\/|:\\d+|\\?|#)', 'i');
    },

    /**
     * Удаляет www из имени домена
     * @param {string} domain домен
     * @returns {string}
     */
    stripWww: function(domain) {
        domain = $.trim(domain).toLowerCase();
        if (domain.match(/^www\..*\./) && !domain.match('^www\\.' + u.commonDomainRegExp + '$')) {
            domain = domain.replace(/^www\./, '');
        }
        return domain;
    },

    /**
     * Удаляет http:// из имени домена
     * @param {String} domain
     * @returns {String}
     */
    stripHttp: function(domain) {
        if (!this.extractDomain(domain)) return '';

        domain = $.trim(domain);

        if (domain.match(/^http:\/\/.+/i)) {
            domain = domain.replace(/^^http:\/\//i, '');
        } else if (domain.match(/^https:\/\/.+/i)) {
            domain = domain.replace(/^^https:\/\//i, '');
        }

        return domain;
    },

    /**
     * Проверяет валидность ссылка
     * @param {string} href ссылка
     * @returns {*|Array|{index: number, input: string}|Boolean|Object}
     */
    validateHref: function(href) {
        return $.trim(href).match(u.hrefRegExp());
    },

    /**
     * Получение параметров текущего url с возможностью переопределения параметров
     * @param {String[]} skipNames имена параметров, которые будут исключены из результата
     * @param {Object} params параметры, которые переопределят параметры в текущем url или добавлятся к результату
     * @returns {Object}
     */
    getUrlParams: function(skipNames, params) {
        var locationParams = u.parseUrl(document.location.href).query;

        ['uid_url', 'INCLUDE_PATH', 'ncrnd', 'UID']
            .concat(skipNames || [])
            .forEach(function(name) {
                if (name in locationParams) {
                    delete locationParams[name];
                }
            });

        return u._.assign(locationParams, params);
    }
});
