describe('i-utils__url', function() {

    describe('formatHref', function() {
        it('Должен вернуть ссылку без изменений', function() {
            expect(u.formatHref('http://ya.ru')).to.be.equal('http://ya.ru');
            expect(u.formatHref('HtTp://ya.ru')).to.be.equal('HtTp://ya.ru');
        });

        it('Должен вернуть ссылку с протоколом', function() {
            expect(u.formatHref('ya.ru')).to.be.equal('http://ya.ru');
        });

        it('Должен подставлять в ссылку openstat', function() {
            expect(u.formatHref('ya.ru', true)).to.be.equal('http://ya.ru?_openstat=dGVzdDsxOzE7');
        });

        it('Должен корректно обрабатывать хеш при подстановке openstat', function() {
            expect(u.formatHref('ya.ru#anchor', true)).to.be.equal('http://ya.ru?_openstat=dGVzdDsxOzE7#anchor');
        });
    });

    describe('getNewsArchiveUrl', function() {
        var sandbox,
            constStub;

        beforeEach(function() {
            sandbox = sinon.sandbox.create();
            constStub = sandbox.stub(u, 'consts');
        });

        afterEach(function() {
            sandbox.restore();
        });

        it('должны корректно подставляться параметры url', function(){
            constStub.withArgs('tld').returns('123');
            constStub.withArgs('newsArchiveUrl').returns('=<tld>=');

            expect(u.getNewsArchiveUrl()).to.equal('=123=');
        });
    });

    describe('getUrl', function() {
        beforeEach(function() {
            sinon.stub(u, 'consts')
                .withArgs('csrf_token').returns('token')
                .withArgs('SCRIPT').returns('http://direct.yandex.ru/registered/main.pl')
                .withArgs('SCRIPT_OBJECT').returns(u.getScriptObjectForStub());
        });

        afterEach(function() {
            u.consts.restore();
        });

        it('должен добавлять в результирующий url csrf-токен', function() {
            expect(u.getUrl('showCamp')).to.contain('csrf_token=token');
        });

        it('должен подставлять первый параметр как cmd', function() {
            expect(u.getUrl('showCamp')).to.contain('cmd=showCamp');
        });

        it('должен подставлять парамeтры из хеша параметров в результирующий url парами ключ=значение', function() {
            var resUrl = u.getUrl('showCamp', { cid: 261, ulogin: 'holodilnikru' });

            expect(resUrl).to.contain('cid=261');
            expect(resUrl).to.contain('ulogin=holodilnikru');
        });

        it('должен подставлять параметры со значением undefined как пустые', function() {
            var resUrl = u.getUrl('showCamp', { ulogin: undefined });

            expect(resUrl).to.eql('http://direct.yandex.ru/registered/main.pl?cmd=showCamp&ulogin=&csrf_token=token');
        });

        it('должен возвращать абсолютный путь', function() {
            var resUrl = u.getUrl('showCamp');

            expect(resUrl).to.contain('http://direct.yandex.ru');
        });

        it('должен ставить параметр cmd - первым', function() {
            var resUrl = u.getUrl('showCamp', { cid: 1642 });

            expect(resUrl).to.contain('?cmd=showCamp');
        });

        it('должен одновременно добавлять в параметры cmd, csrf_token и ключи/значения из переданного хеша', function() {
            expect(u.parseUrl(u.getUrl('showCamp', { cid: 261, ulogin: 'holodilnikru' }))).to.be.eql(
                u.parseUrl('http://direct.yandex.ru/registered/main.pl?cmd=showCamp&cid=261&ulogin=holodilnikru&csrf_token=token'));
        });
    });

    describe('getImageUrl', function() {
        it('с mdsGroupId формирует /images/namespace/mdsGroupId/hash/size/', function() {
            expect(u.getImageUrl({ mdsGroupId: '666', hash: '9zsQ715YgKaoDwFjo7snMQ', namespace: 'bayan', size: 'x90' }))
                .to.be.eql('/images/bayan/666/9zsQ715YgKaoDwFjo7snMQ/x90');
        });

        it('без mdsGroupId формирует /images/hash/size', function() {
            expect(u.getImageUrl({ hash: '9zsQ715YgKaoDwFjo7snMQ', size: 'x90' }))
                .to.be.eql('/images/9zsQ715YgKaoDwFjo7snMQ/x90');
        });

        it('c namespace', function() {
            expect(u.getImageUrl({ mdsGroupId: '666', hash: '9zsQ715YgKaoDwFjo7snMQ', namespace: 'bayan' }))
                .to.be.eql('/images/bayan/666/9zsQ715YgKaoDwFjo7snMQ');
        });

        it('без namespace подставляется direct', function() {
            expect(u.getImageUrl({ mdsGroupId: '666', hash: '9zsQ715YgKaoDwFjo7snMQ' }))
                .to.be.eql('/images/direct/666/9zsQ715YgKaoDwFjo7snMQ');
        });

    });
});
