u.register({
    /**
     * Методы для работы с url
     * @namespace u.url
     */
    url: {

        /**
         * Возвращает ссылку на региональный домен,
         * формируется с учетом локали пользователя
         *
         * @returns {String}
         */
        getRegionalDomain: function() {
            var yDomain = '//yandex.' + u.consts('tld');

            return /kz|by/.test(yDomain) ? '//yandex.ru' : yDomain;
        }
    }
});

(function() {
    //@heliarian здесь остались элементы i-utils__url неотторгаемые от директа (из-за директовских констант)
    //остальное перенесено в bricks
    u.register(/** @namespace u */ {
        /**
         * Нормализует ссылку с учетом openstat
         * @see TTTools.pm formatHref
         *
         * @param {String} href
         * @param {Boolean} openstat
         */
        formatHref: function(href, openstat) {
            return u.getPreviewUrl(href, u.getPreviewUrlParams(null, openstat));
        },

        /**
         * Получение url для заданного cmd с опциональным указанием параметров
         * @param {String} cmd
         * @param {Object} [params]
         * @param {Object} [options]
         * @returns {String}
         */
        getUrl: function(cmd, params, options) {
            var scriptUrlObject = u.consts('SCRIPT_OBJECT') || {},
                optSuffix = (options || {}).suffix,
                suffix = scriptUrlObject.suffix || '';

            if (optSuffix !== undefined) {
                suffix = optSuffix;
            }

            return u.formatUrl({
                protocol: scriptUrlObject.protocol,
                host: scriptUrlObject.host,
                path: '/registered/main.pl' + suffix,
                query: u._.mapValues(u._.assign({ cmd: null }, params, { // для вынесения cmd на первое место в списке параметров
                    cmd: cmd,
                    csrf_token: u.consts('csrf_token')
                }), function(param) {
                    // значения параметров могут быть null или undefined,
                    // при этом не нужно превращать их в строки 'null' или 'undefined' DIRECT-70117
                    return param === undefined || param === null ? '' : encodeURIComponent(param); //поведение перлового get_url
                })
            }, true);
        },

        /**
         * Получение текущего url с возможностью переопределения параметров
         * getUrlParams переопределяется в i-utils__url.js или в i-utils__url.bemtree.xjst
         * @param {Object} [params]
         * @returns {String}
         */
        getCurrentUrl: function(params) {
            return u.getUrl(params && params.cmd || u.consts('cmd'), u.getUrlParams(['cmd'], params));
        },

        /**
         * Формирует URL архива новостей по шаблону, полученному с бекэнда
         * @returns {String}
         */
        getNewsArchiveUrl: function() {
            var locale = u.consts('locale'),
                tld = u.consts('lang') == 'en' ?
                    'com' :
                    u.consts('lang') == 'ru' && u.consts('tld') == 'com' ?
                        'ru' : u.consts('tld'),
                tag = tld == 'com' || tld == 'com.tr' ? 'yandex-direct' : 'direkt',
                pattern = u.consts('newsArchiveUrl');

            return pattern
                .replace('<tld>', tld)
                .replace('<tag>', tag);
        },

        /**
         * Возвращает ссылку на хелп по идентификатору и языку
         * @param {String} id идентификатор в doccenter
         * @param {String} [lang] язык
         */
        getHelpUrl: function(id, lang) {
            lang = lang || u.consts('lang');

            return u.formatUrl({
                path: '/tooltip.html',
                query: { id: id, lang: lang }
            });
        },

        /**
         * Возвращает ссылку на общий хелп
         * @param {String} path путь к странице помощи
         * @returns {String}
         */
        getCommonHelpUrl: function(path) {
            return u.formatUrl({
                host: u.url.getRegionalDomain() + '/support',
                path: path
            });
        },

        getLegalHelpUrl: function(path) {
            if (u.consts('enabledChangeOfferForClientsFromTurkey')) {
                return u.formatUrl({
                    host: '//yandex.com',
                    path: '/legal/oferta_direct_ch/'
                })
            }

            return u.formatUrl({
                host: u.url.getRegionalDomain() + '/legal',
                path: path
            });
        },

        /**
         * Формирует урл картинки в Аватарнице
         * @param {Object} data
         * @param {String} data.hash
         * @param {String} [data.mdsGroupId]
         * @param {String} [data.namespace]
         * @param {String} [data.size]
         * @param {Object} [options] дополнительные опции
         * @param {Boolean} [options.fullPath] генерировать полный путь
         * @returns {String}
         */
        getImageUrl: function(data, options) {
            var url = data.mdsGroupId ?
                    ['/images', data.namespace || 'direct', data.mdsGroupId, data.hash] :
                    ['/images', data.hash],
                scriptUrlObject = u.consts('SCRIPT_OBJECT');

            data.size && url.push(data.size);

            return options && options.fullPath ?
                u.formatUrl({
                    protocol: scriptUrlObject.protocol,
                    host: scriptUrlObject.host,
                    path: url.join('/')
                }) :
                url.join('/');
        },

        /**
         * Преобразовует хеш с параметрами ссылки в строку параметров
         * @param {Object} urlParams Хеш с парамтреми
         * @returns {String}
         */
        queryParamsToString: function(urlParams) {
            urlParams = Object.keys(urlParams).reduce(function(str, key) {
                var paramKey = key,
                    paramVal = urlParams[paramKey] || ''; // обрабатываем краевые случаи c undefined

                str += paramKey + '=' + paramVal + '&';

                return str;
            }, '');

            return urlParams.substr(0, urlParams.length - 1);
        },

        /**
         * Возвращает разницу между query параметрами
         * @param {String} url1
         * @param {String} url2 — эталон
         * @returns {Object}
         */
        getDiffQueryParams: function(url1, url2) {
            return u._.omit(u.parseUrl(url1).query, u._.keys(u.parseUrl(url2).query));
        },

        /**
         * Возвращает ссылку на формирование пинкода поддержки
         * @returns {String}
         */
        getPassportSupportPinCodeUrl: function() {
            var scriptUrlObject = u.consts('SCRIPT_OBJECT');

            return u.formatUrl({
                protocol: scriptUrlObject.protocol,
                host: scriptUrlObject.host,
                path: '/profile/supportcode',
                query: { origin: 'direct' }
            });
        },

        /**
         * Проверяет, является ли ссылка ссылкой на формирование пинкода поддержки
         * @param {String} url
         * @returns {String}
         */
        isPassportSupportPinCodeUrl: function(url) {
            var urlObject = u.parseUrl(url);

            return urlObject.path === '/profile/supportcode' && urlObject.query.origin === 'direct';
        }
    });
}());
