(function() {
    function getRequest() {
        return _request || (_request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            type: 'POST',
            callbackCtx: this
        }));
    }

    function getUserOptions() {
        return _userOptions || (_userOptions || JSON.parse(u.consts('user_options')));
    }

    var _request,
        _userOptions,
        userOptions = {
            /**
             * Записывает значение value в поле name в USER_OPTIONS
             * @param {String} name - имя поля
             * @param {*} value значение поля
             * @param {Function} [callback]
             */
            set: function(name, value, callback) {
                var campOptions = getUserOptions(),
                    saveData = { cmd: 'ajaxUserOptions' };

                callback = callback || function() {};

                campOptions[name] = saveData[name] = value;
                getRequest().get(saveData, callback);
            },

            /**
             * Записывает данные в USER_OPTIONS
             * @param {Object} data - объект с данными, которые надо сохранить
             * @param {Function} [callback]
             */
            update: function(data, callback) {
                var campOptions = getUserOptions(),
                    saveData = { cmd: 'ajaxUserOptions' };

                Object.keys(data).forEach(function(key) {
                    campOptions[key] = saveData[key] = data[key];
                });

                callback = callback || function() {};

                getRequest().get(saveData, callback);
            },

            /**
             * Удаляет поле name из USER_OPTIONS
             * @param {String} name
             * @param {Function} [callback]
             */
            remove: function(name, callback) {
                getUserOptions()[name] = null;

                callback = callback || function() {};

                getRequest().get({ cmd: 'ajaxUserOptions', delete: name }, callback);
            },

            get: function(name) {
                return getUserOptions()[name];
            }
        };

    u.register({
        userOptions: userOptions
    });

})();
