(function(ctx) {

    var hasCookie = function(name) {
        return !!((ctx.data || {}).COOKIES ? (ctx.data || {}).COOKIES[name] : $.cookie(name));
    };

    u.register({
        /**
         * Проверяет, доступна ли для данного пользователя функциональность на бете
         * @param {String} name имя фича-флага
         * @returns {Boolean}
         */
        hasFeature: function(name) {
            return u.consts('is_beta') && u.hasProductionFeature(name);
        },

        /**
         * Проверяет, доступна ли для данного пользователя функциональность в продакшене
         * @param {String} name имя фича-флага
         * @returns {Boolean}
         */
        hasProductionFeature: function(name) {
            var featuriesList = u.consts('visible_futures') || [];

            return featuriesList && featuriesList.indexOf(name) !== -1;
        },

        /**
         * Проверяет, установленная ли кука
         * @param {String} name название куки
         * @returns {Boolean}
         */
        hasCookie: hasCookie,

        /**
         * Проверяет, доступна ли для данного пользователя функциональность в продакшене через фича-флаги либо через куку
         * @param {String} name имя фича-флага/куки
         * @returns {Boolean}
         */
        hasProductionFeatureOrCookie: function(name) {
            return u.hasProductionFeature(name) || u.hasCookie(name);
        }
    });

})(this);
