block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    var data = this.data;

    u.register({
        /**
         * Возвращает информацию по ограничениям на использование общего счета
         * @param {Object} wallet данные общего счета
         * @returns {Object}
         */
        getWalletRestrictions: function(wallet) {
            var isSuperAccess = hasLoginRights('agency_control', 'super_control', 'manager_control',
                    'support_control') || hasLoginRights('is_developer') && !hasLoginRights('superreader_control'),
                isAllowToChangeEnableWallet = !!(wallet.enabled ?
                    (+wallet.allow_disable_wallet || isSuperAccess) :
                    +wallet.allow_enable_wallet),
                isAllowTransferMoney = !!+wallet.allow_transfer_money || isSuperAccess,
                // Редактирование не доступно: вешальщикам, суперридерам, медиапланерам, клиентским менеджерам (mcc)
                isReadOnlyWallet = hasLoginRights('placer_control', 'media_control', 'superreader_control') || Boolean(data.is_mcc_control),
                // просмотр недоступен медиапланеру и вешальщику
                dontShowWalletLink = hasLoginRights('placer_control', 'media_control'),
                isAllowedPay = !!wallet.allow_pay &&
                    // ограниченным представителям у которых нет возможности выставления счёта
                    (!hasLoginRights('is_agency_limited') || !hasLoginRights('agency_limited_no_pay')),
                needOnlyCampModerationToPay = +wallet.need_camp_moderation_to_pay === 1,
                isAllowedEditCamps = wallet.agencyID ?
                    !!+wallet.is_super_subclient || isSuperAccess :
                    true;

            return {
                // Есть ли возможность включать/выключать общий счет
                isAllowToChangeEnableWallet: isAllowToChangeEnableWallet,
                // Пазрешен ли перенос средств между кампаниями
                isAllowTransferMoney: isAllowTransferMoney,
                // настройки ОС доступны только на чтение
                isReadOnlyWallet: isReadOnlyWallet,
                // доступен просмотр настроек ОС
                dontShowWalletLink: dontShowWalletLink,
                // Разрашена ли оплата кампаний
                isAllowedPay: isAllowedPay,
                // флаг, что пользователю мешают оплатить только непромодерированные кампании
                needOnlyCampModerationToPay: needOnlyCampModerationToPay,
                // Право "редактировать кампанию" в настройках пользователя
                isAllowedEditCamps: isAllowedEditCamps
            };
        },

        /**
         * Возвращает ссылку на страницу ОС
         * @param {String} [agencyID] идентификатор агенства
         * @returns {String}
         */
        getWalletLink: function(agencyID, extraParams) {
            var walletLinkParams = extraParams ? u._.extend({}, extraParams) : {};

            if (data.user_login) {
                walletLinkParams.ulogin = data.user_login;
            }

            // для самоходных клиентов agencyID приходит = '0'
            if (agencyID && agencyID != 0) {
                walletLinkParams.AgencyID = agencyID;
            }

            return u.getUrl('clientWallet', walletLinkParams);
        }
    });

    return applyNext();
});
