(function() {
    var dayNames = {
        0: iget2('i-utils', 'pn', 'пн'),
        1: iget2('i-utils', 'vt', 'вт'),
        2: iget2('i-utils', 'sr', 'ср'),
        3: iget2('i-utils', 'cht', 'чт'),
        4: iget2('i-utils', 'pt', 'пт'),
        5: iget2('i-utils', 'sb', 'сб'),
        6: iget2('i-utils', 'vs', 'вс')
    };

    function getTimeFromApi(
        hours,
        minutes,
        isEndTime
    ) {
        if (isEndTime && hours === 0 && minutes === 0) {
            return '24:00';
        }

        var res = '';
        res += hours >= 10 ? hours : '0' + hours;
        res += ':';
        res += minutes >= 10 ? minutes : '0' + minutes;

        return res;
    }

    u.register({

        /**
         * Названия дней недели
         */
        worktimeDayNames: dayNames,

        /**
         * Преобразует серверное время работы в человеко-понятное
         * Например, u.worktime('0#5#09#00#17#30;6#6#09#00#16#00') === 'Пн-сб 9:00-17:30, вс 9:00-16:00'
         * Если указан круглосуточный режим работы, не показывать дни недели --'Пн-вс'--
         * @param {String} str серверное время работы
         * @returns {String}
         */
        worktime: function(str) {
            var to2 = function(number) { return (number < 10 ? '0' : '') + number },
                res = str.split(';').map(function(ch) {
                    var d = ch.split('#'),
                        d1 = +d[0],
                        d2 = +d[1],
                        h1 = +d[2],
                        m1 = +d[3],
                        h2 = +d[4],
                        m2 = +d[5],
                        dayAndNight = !h1 && !m1 && (!h2 && !m2 || h2 === 23 && m2 > 45),
                        time = dayAndNight ?
                            iget2('i-utils', 'kruglosutochno', 'Круглосуточно') :
                            h1 + ':' + to2(m1) + '-' + h2 + ':' + to2(m2);

                    return (dayAndNight && d1 === 0 && d2 === 6 ? '' : dayNames[d1] + (d1 !== d2 ? '-' + dayNames[d2] : '') + ' ') +
                        time;
                }).join(', ');

            return u.ucfirst(res);
        },

        mapWorkTimesFromApi: function(periods) {
            var res = periods
                .map(function(period) {
                    if (period.daysOfWeek.length === 1) {
                        return dayNames[period.daysOfWeek[0]] + ' ' + getTimeFromApi(period.startTime.hour, period.startTime.minutes) + '-' + getTimeFromApi(period.endTime.hour, period.endTime.minutes, true);
                    } else {
                        return (dayNames[period.daysOfWeek[0]] +
                            '-' +
                            dayNames[period.daysOfWeek[period.daysOfWeek.length - 1]] +
                            ' ' +
                            getTimeFromApi(period.startTime.hour, period.startTime.minutes) +
                            '-' +
                            getTimeFromApi(period.endTime.hour, period.endTime.minutes, true)
                        );
                    }
                })
                .join(', ');

            return u.ucfirst(res);
        }
    });
})();
