/* borschik:include:../../node_modules/swagger-client/browser/swagger-client.min.js */

(function() {
    var SwaggerClient = window.SwaggerClient,
        ApiKeyAuthorization = SwaggerClient.ApiKeyAuthorization,
        clientPromise;

    function getObject(response) {
        return response.obj;
    }

    function getClient() {
        return clientPromise || (clientPromise = new SwaggerClient({
            url: '/web-api/docs/api',
            usePromise: true,
            requestInterceptor: function() {
                this.headers['X-Detected-Locale'] = u.consts('lang') === 'ua' ? 'uk' : u.consts('lang');

                // IE Cache fix
                this.headers['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
                this.headers['Cache-Control'] = 'no-cache';
                this.headers['Pragma'] = 'no-cache';
            }
        }).then(function(client) {
            // При получении схемы апи прилетает зашитый хост беты, с которой была получена схема.
            // В итоге все запросы делаются именно на него, и при локальной разработке в DNA валятся из-за CSP
            client.setHost(window.location.host);
            client.clientAuthorizations
                .add('csrf_token', new ApiKeyAuthorization('X-CSRF-TOKEN', u.consts('csrf_token'), 'header'));

            return client;
        }));
    }

    function transformVcard(response) {
        var data = getObject(response),
            worktimes;

        if (data.success && (worktimes = u._.get(data, 'result.new_vcard.worktimes'))) {
            worktimes.forEach(function(item) {
                item.d1 = u.worktimeDayNames[item.d1] || item.d1;
                item.d2 = u.worktimeDayNames[item.d2] || item.d2;
            });
        }

        return data;
    }

    BEM.decl('i-web-api-request', {}, {
        retargeting: {

            /**
                @typedef RetargetingCondition
                @type {object}
                @property {Number} id - id условия (если не указан, создается новое условие)
                @property {String} name - название условия
                @property {String} description - примечание
                @property {Array} conditions - наборы правил
                @property {Array} conditions[0].type - тип условия ('all', 'or', 'not')
                @property {Array} conditions[0].goals - правила
                @property {Number} conditions[0].goals[0].id - цели
                @property {Number} conditions[0].goals[0].time - период (в днях)
            **/

            /**
             * Возвращает список целей ретаргетинга для заданного логина
             * @param {String} ulogin
             * @return {Promise}
             */
            getGoals: function(ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .getGoalsForRetargeting({ ulogin: ulogin })
                        .then(getObject);
                });
            },

            /**
             * Замена целей в условии ретаргетинга
             * @param {{ new_goal_id:number, old_goal_id:number }[]} data
             * @param {String} ulogin
             * @return {Promise}
             */
            replaceGoals: function(data, ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .replaceGoalsInRetargetings({ replaceGoals: data, ulogin: ulogin })
                        .then(getObject);
                });
            },

            /**
             * Возвращает список условий ретаргетинга вместе с целями по id
             * @param {Number[]} ids - массив id нужных условий ретаргетинга
             * @param {String} ulogin
             */
            getConditions: function(ids, ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .ajaxGetRetCondWithGoals({ retargetingConditionIds: ids, ulogin: ulogin })
                        .then(getObject)
                });
            },

            /**
             * Сохранение условия
             * @param {RetargetingCondition} data - условие подбора аудитории
             * @param {String} ulogin
             * @return {Promise}
             */
            saveCondition: function(data, ulogin) {
                return getClient().then(function(client) {
                    var method = data.id ?
                        client.retargeting.updateRetargetingCondition :
                        client.retargeting.createRetargetingCondition;

                    return method({ ulogin: ulogin, retargetingConditionWeb: data })
                        .then(getObject);
                });
            },

            /**
             * Удаление условий ретаргетинга
             * @param {Number[]} ids - массив id удаляемых условий
             * @param {String} ulogin
             * @return {Promise}
             */
            deleteCondition: function(ids, ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .deleteRetargetingCondition({ retCondIds: ids, ulogin: ulogin })
                        .then(getObject);
                });
            },

            /**
             * Получение прогноза количества посетителей для условия
             * @param {RetargetingCondition} data - условие подбора аудитории
             * @param {String} ulogin
             * @return {Promise}
             */
            estimateCondition: function(data, ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .retargetingCondEstimate({ ulogin: ulogin, retargetingConditionWeb: data })
                        .then(getObject);
                });
            },

            /**
             * Выключение условий ретаргетинга
             * @param {Number[]} ids - массив id удаляемых условий
             * @param {String} ulogin
             * @return {Promise}
             */
            suspendConditions: function(ids, ulogin) {
                return getClient().then(function(client) {
                    return client.retargeting
                        .suspendRetargetingConditions({ retCondIds: ids, ulogin: ulogin })
                        .then(getObject);
                });
            }
        },

        adGroups: {
            /**
             * Возвращает сегменты крипты
             * @return {Promise}
             */
            save: function(data) {
                return getClient().then(function(client) {
                    return client.adGroups
                        .save({
                            ulogin: data.ulogin,
                            adGroups: data.adGroups,
                            campaign_id: data.campaign_id,
                            is_new_adgroups: data.is_new_adgroups,
                            save_draft: data.save_draft,
                            is_copy: data.is_copy,
                            camp_banners_domain: data.camp_banners_domain
                        })
                        .then(getObject);
                });
            },

            saveCpmAdGroup: function(data) {
                return getClient().then(function(client) {
                    return client.adGroups
                        .saveCpmAdGroupUsingPOST({
                            ulogin: data.ulogin,
                            adGroups: data.adGroups,
                            campaign_id: data.campaign_id,
                            is_new_adgroups: data.is_new_adgroups,
                            save_draft: data.save_draft,
                            is_copy: data.is_copy,
                            camp_banners_domain: data.camp_banners_domain
                        })
                        .then(getObject);
                });
            },

            saveContentPromotionVideoAdGroup: function(data) {
                return getClient().then(function(client) {
                    return client.adGroups
                        .saveContentPromotionVideoAdGroupUsingPOST({
                            ulogin: data.ulogin,
                            adGroups: data.adGroups,
                            campaign_id: data.campaign_id,
                            is_new_adgroups: data.is_new_adgroups,
                            save_draft: data.save_draft,
                            is_copy: data.is_copy,
                        })
                        .then(getObject);
                });
            }

        },

        crypta: {

            /**
             * Возвращает сегменты крипты
             * @param {String} ulogin
             * @param {String} type - тип сегмента крипты
             * @param {String} filter
             * @return {Promise}
             */
            getCryptaSegments: function(ulogin, type, filter) {
                return getClient().then(function(client) {
                    return client.crypta
                        .getCryptaSegments({ ulogin: ulogin, type: type, filter: filter })
                        .then(getObject);
                });
            }

        },

        mediareach: {

            /**
             * Получение прогноза
             * @param {String} ulogin - логин пользователя
             * @param {ReachParams} data - данные для прогноза
             */
            getReach: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getReach({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            },

            /**
             * Получение рекомендаций
             * @param {String} ulogin - логин пользователя
             * @param {ReachParams} data - данные для рекомендации
             */
            getReachRecommendation: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getReachRecommendation({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            },

            /**
             * Получение расчета охвата аудитории outdoor группы объявлений
             * @param {String} ulogin - логин пользователя
             * @param {ReachParams} data - данные для рекомендации
             */
            getReachOutdoor: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getReachOutdoor({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            },

            /**
             * Получение расчета охвата аудитории indoor группы объявлений
             * @param {String} ulogin - логин пользователя
             * @param {ReachParams} data - данные для рекомендации
             */
            getReachIndoor: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getReachIndoor({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            },

            /**
             * Получение прогноза для cpm стратегий
             * @param {String} ulogin - логин пользователя
             * @param {ReachParams} data - данные для прогнозатора
             */
            getCampaignForecast: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getCampaignForecast({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            },

            getCpmTrafficLightPrediction: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.mediareach
                        .getCpmTrafficLightPrediction({ ulogin: ulogin, request: data })
                        .then(getObject);
                });
            }
        },

        metrikaCounters: {
            /**
             * добавление счетчиков метрики в кампании
             * @param {Object} options - опции запроса
             * @param {String} options.ulogin - логин пользователя
             * @param {Array} options.cids - список cid-ов кампаний
             * @param {Array} options.counters - список счетчиков метрики
             * @returns {Promise}
             */
            add: function(options) {
                return getClient().then(function(client) {
                    return client.campaign
                        .addMetrikaCounters({
                            ulogin: options.ulogin,
                            webRequest: {
                                cids: options.cids,
                                metrika_counters: options.counters
                            }
                        })
                        .then(getObject);
                });
            },

            /**
             * добавление счетчиков метрики в кампании
             * @param {Object} options - опции запроса
             * @param {String} options.ulogin - логин пользователя
             * @param {Array} options.cids - список cid-ов кампаний
             * @param {Array} options.counters - список счетчиков метрики
             * @returns {Promise}
             */
            replace: function(options) {
                return getClient().then(function(client) {
                    return client.campaign
                        .replaceMetrikaCounters({
                            ulogin: options.ulogin,
                            webRequest: {
                                cids: options.cids,
                                metrika_counters: options.counters
                            }
                        })
                        .then(getObject);
                })
            },

            /**
             * Удаление всех счетчиков метрики
             * @param {Object} options - опции запроса
             * @param {String} options.ulogin - логин пользователя
             * @param {Array} options.cids - список cid-ов кампаний
             * @returns {*}
             */
            deleteAll: function(options) {
                return getClient().then(function(client) {
                    return client.campaign
                        .deleteMetrikaCounters({
                            ulogin: options.ulogin,
                            webRequest: {
                                cids: options.cids
                            }
                        })
                        .then(getObject);
                })
            }
        },

        privateDeals: {

            /**
             * Возвращает список сделок для заданного логина
             * @param {String} ulogin
             * @param {String} [sort]
             * @param {String} [reverse]
             * @param {Boolean} [noStat]
             * @return {Promise}
             */
            getDealsList: function(ulogin, sort, reverse, noStat) {
                return getClient().then(function(client) {
                    return client.deal
                        .getDealsList({
                            ulogin: ulogin,
                            sort_by: sort,
                            sort_order: reverse,
                            no_stat: noStat
                        })
                        .then(getObject);
                });
            },

            /**
             * Возвращает подробную информацию о сделках по id
             * @param {String} ulogin
             * @param {Array} ids
             * @return {Promise}
             */
            getDealsDetails: function(ulogin, ids) {
                return getClient().then(function(client) {
                    return client.deal
                        .getDealsDetails({ ulogin: ulogin, dealIds: ids })
                        .then(getObject);
                });
            },

            /**
             * Переводит выбранные сделки в статус "Активна"
             * @param {String} ulogin
             * @param {Array} ids
             * @return {Promise}
             */
            activateDeals: function(ulogin, ids) {
                return getClient().then(function(client) {
                    return client.deal
                        .activateDeals({ ulogin: ulogin, dealIds: ids })
                        .then(getObject);
                });
            },

            /**
             * Переводит выбранные сделки в статус "Завершена"
             * @param {String} ulogin
             * @param {Array} ids
             * @return {Promise}
             */
            completeDeals: function(ulogin, ids) {
                return getClient().then(function(client) {
                    return client.deal
                        .completeDeals({ ulogin: ulogin, dealIds: ids })
                        .then(getObject);
                });
            },

            updateDeals: function(ulogin, request) {
                return getClient().then(function(client) {
                    return client.deal
                        .updateDeals({ ulogin: ulogin, request: request })
                        .then(getObject);
                });
            },

            getSubClients: function(ulogin) {
                return getClient().then(function(client) {
                    return client.agency
                        .searchAgencySubClientsForDeals({ ulogin: ulogin })
                        .then(getObject);
                });
            },

            getDealCampaigns: function(ulogin) {
                return getClient().then(function(client) {
                    return client.campaign
                        .searchDealCampaigns({ ulogin: ulogin })
                        .then(getObject);
                });
            }
        },

        vcards: {

            /**
             * Назначение визитки объявлениям
             * @param {String} ulogin
             * @param {Array} bids
             * @param {String} cid
             * @param {String} vcardId
             * @return {Promise}
             */
            assignVcard: function(ulogin, bids, cid, vcardId) {
                return getClient().then(function(client) {
                    return client.vcard
                        .assignVcard({
                            ulogin: ulogin,
                            webRequest: {
                                bids: [].concat(bids || []).map(Number),
                                cid: Number(cid),
                                vcard_id: Number(vcardId)
                            }
                        })
                        .then(transformVcard);
                });
            },

            /**
             * Отвязка визитки от баннера
             * @param {String} ulogin
             * @param {String|Array} bids
             * @param {String} cid
             */
            unassignVcard: function(ulogin, bids, cid) {
                return getClient().then(function(client) {
                    return client.vcard
                        .unassignVcard({
                            ulogin: ulogin,
                            webRequest: {
                                bids: [].concat(bids || []).map(Number),
                                cid: Number(cid)
                            }
                        })
                        .then(getObject);
                });
            },

            /**
             * Сохранение визитки после редактирования
             * @param {String} ulogin
             * @param {Object} vcard - данные визитки в формате java ручки
             */
            saveVcard: function(ulogin, vcard) {
                return getClient().then(function(client) {
                    return client.vcard
                        .saveVcard({
                            ulogin: ulogin,
                            webRequest: {
                                bids: vcard.bids,
                                cid: vcard.campaign_id,
                                vcard_id: vcard.id,
                                vcard: vcard
                            }
                        })
                        .then(transformVcard, getObject);
                });
            }
        },

        grid: {
            /**
             * Отправка отзыва о dna
             * @param {String} message - текст сообщения отзыва
             * @param {String} url - URL страницы с которой отправлено
             */
            sendFeedback: function(message, url) {
                return getClient().then(function(client) {
                    return client.feedback
                        .grid({
                            request: {
                                message: message,
                                url: url,
                                isFromOldInterface: true
                            }
                        })
                        .then(getObject);
                });
            }
        },

        feature: {
            /**
             * Включает/выключает выбранную фичу
             * @param {Boolean} stateItems
             * @param {String} ulogin - login Пользователя
             * @return {Promise}
             */
            setState: function(stateItems, ulogin) {
                return getClient().then(function(client) {
                    return client.feature
                        .setStateUsingPOST({ stateItems: stateItems, ulogin: ulogin })
                        .then(getObject);
                });
            }
        },

        mobileApps: {
            /**
             * Получение списка всех приложений пользователя
             * @param {String} ulogin - login Пользователя
             * @returns {Promise}
             */
            getAppsList: function(ulogin) {
                return getClient().then(function(client) {
                    return client.mobile_app
                        .getMobileAppList({ ulogin: ulogin })
                        .then(getObject);
                })
            },

            /**
             * Получение данных о мобильном приложении из (Appstore|GooglePlay)
             * @param {String} ulogin - login Пользователя
             * @param {String} url - Ссылка на приложение в (Appstore|GooglePlay)
             * @returns {Promise}
             */
            getAppContent: function(ulogin, url) {
                return getClient().then(function(client) {
                    return client.mobile_app
                        .getMobileContent({
                            ulogin: ulogin,
                            url: url
                        })
                        .then(getObject);
                });
            },
        },

        moderationReason: {
            /**
             * Получение контента для новых причин отклонения модерации
             * @param {String[]} reasons - массив id причин отказа модерации
             * @returns {Promise}
             */
            getModerationDeclineReasonsContent: function(reasons) {
                return getClient().then(function(client) {
                    var tld = u.consts('tld'),
                        lang = u.consts('lang');

                    return client.moderationreason.showModReasonsUsingPOST({
                        request: {
                            ids: reasons,
                            tld: (tld === 'kz' || tld === 'by') ? 'ru' : tld, // @tgnc: для kz или by доменнов показываем русский хэлп (DIRECT-92692)
                            lang: lang
                        }
                    })
                        .then(getObject)
                })
            }
        },

        bannerPagesModeration: {

            /**
             * Перемодерация объявлений для наружной рекламы
             * @param {String} ulogin
             * @param {Object} data
             * @param {Number} data.banner_id
             * @param {Array} data.page_ids
             * @returns {Promise}
             */
            remoderateBannerPage: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.bannerPagesModeration
                        .remoderateBannerPage({ ulogin: ulogin, input: data })
                        .then(getObject);
                });
            }

        },

        placements: {

            get: function(data) {
                return getClient().then(function(client) {
                    return client.placements
                        .getPlacementsUsingGET({
                            ulogin: data.ulogin,
                            placementType: data.placementType
                        })
                        .then(getObject);
                })
            }

        },

        contentPromotion: {

            /**
             * Получение метаданных по видеоматериалу (для content_promotion)
             * @param {String} ulogin
             * @param {String} contentType ["collection" | "video"]
             * @param {String} contentHref
             * @param {Number} campaignId
             * @param {Number} adgroupId
             * @returns {Promise}
             */
            getContentPromotionMetadata: function(ulogin, contentType, contentHref, campaignId, adgroupId) {
                return getClient().then(function(client) {
                    return client['content-promotion']
                        .getContentPromotionMeta({
                            ulogin: ulogin,
                            request: {
                                adgroup_id: adgroupId || 0,
                                campaign_id: campaignId || 0,
                                url: contentHref,
                                content_promotion_type: contentType
                            }
                        })
                        .then(getObject);
                });
            }

        },

        cpmYndxFrontpage: {
            /**
             * Получаение данных о ставке по связке регион+ставка
             * Для CPM на главной
             * @param {String} ulogin
             * @param {String} cid
             * @param {String} geo
             * @param {String} price
             * @returns {Promise}
             */
            getCpmYndxFrontpageGeoWarnings: function(ulogin, cid, geo, price) {
                return getClient().then(function(client) {
                    return client.cpmYndxFrontpage
                        .getCpmYndxFrontpageGeoWarningsUsingPOST({
                            ulogin: ulogin,
                            campaign_id: cid,
                            frontpageGeoWarningsGetItem: {
                                geo: geo,
                                price: price
                            }
                        })
                        .then(getObject);
                });
            },

            /**
             *
             * @param {String} ulogin
             * @param {Object} frontpageWarningsRequest
             * @returns {Promise}
             */
            getFrontpagePriceWarnings: function(ulogin, frontpageWarningsRequest) {
                return getClient().then(function(client) {
                    return client.cpmYndxFrontpage
                        .getFrontpagePriceWarningsUsingPOST({
                            ulogin: ulogin,
                            frontpageWarningsRequest: frontpageWarningsRequest
                        })
                        .then(getObject);
                });
            }
        },

        disabledDomains: {
            /**
             * Добавляет площадки с blackList в медийных кампаниях для видеообъявлений
             * Используется на Статистике по площадкам
             * @param {String} ulogin
             * @param {Object} data
             * @returns {Promise}
             */
            disableVideoDomains: function(ulogin, data) {
                return getClient().then(function(client) {
                    return client.disabledVideoDomainsController
                        .disableVideoDomains({
                            ulogin: ulogin,
                            disabledDomainsWeb: data
                        })
                        .then(getObject);
                });
            },

            getInternalPagesDomains: function(ulogin, domains) {
                return getClient().then(function(client) {
                    return client.disabledVideoDomainsController
                        .getInternalPagesDomains({
                            ulogin: ulogin,
                            request: {
                                domains: domains
                            }
                        })
                        .then(getObject);
                });
            }
        },

        brandLift: {

            /**
             * Возращает статус Бренд-лифта
             * @param {String} ulogin
             * @param {String} cid
             * @return {*|{catch}|PromiseLike<T | never>|Promise<T | never>}
             */
            getBrandLift: function(ulogin, cid) {
                return getClient().then(function(client) {
                    return client.campaign.getBrandLift({
                        ulogin: ulogin,
                        cids: [cid]
                    })
                        .then(getObject);
                });
            },

            /**
             * Удаляет опрос Бренд-лифта
             * @param {String} ulogin
             * @param {String} cid
             * @return {*|{catch}|PromiseLike<T | never>|Promise<T | never>}
             */
            deleteBrandLift: function(ulogin, cid) {
                return getClient().then(function(client) {
                    return client.campaign.deleteBrandLift({
                        ulogin: ulogin,
                        cids: [cid]
                    })
                        .then(getObject);
                });
            }

        },

        payment: {
            /**
             * Возвращает строку с ссылкой на форму оплаты траста
             * @see https://8998.beta1.direct.yandex.ru/web-api/docs/swagger-ui.html#!/payment-controller/formUsingPOST
             * @param {String} ulogin
             * @param {Object} params
             * @return {Promise<any> | {catch: function()} | Thenable<any> | PromiseLike<any>}
             */
            getTrustLink: function(ulogin, params) {
                return getClient().then(function(client) {
                    return client['payment-controller'].formUsingPOST({
                        ulogin: ulogin,
                        paymentFormRequest: {
                            sum: params.sum,
                            is_ur: params.is_ur,
                            card_id: params.card_id,
                            promocode: params.promocode,
                            remaining_sum: params.remaining_sum,
                            autopayment_sum: params.autopayment_sum,
                            is_mobile: params.is_mobile
                        }
                    })
                        .then(getObject);
                });
            },

            /**
             * Возвращает список банковских карт клиента и признак "единственный юридический плательщик"
             * @param {String} ulogin
             * @return {{catch: function()}|PromiseLike<any>|Promise<any>}
             */
            getBillingData: function(ulogin) {
                return getClient().then(function(client) {
                    return client['payment-controller'].getBillingDataUsingGET({
                        ulogin: ulogin
                    })
                        .then(getObject);
                });
            }
        },

        measurers: {
            getAuthorizedList: function(ulogin, clientId) {
                return getClient().then(function(client) {
                    return client.client.measurerAccounts({ ClientID: clientId, ulogin: ulogin })
                        .then(getObject);
                })
            }
        },

        smsAuth: {
            getPhoneForSms: function() {
                return getClient().then(function(client) {
                    return client.smsAuth.getSmsPhone()
                        .then(getObject);
                })
            },

            sendSms: function(phoneId) {
                return getClient().then(function(client) {
                    return client.smsAuth.sendSms({ request: { phoneId: phoneId } })
                        .then(getObject);
                })
            },

            checkPassword: function(password) {
                return getClient().then(function(client) {
                    return client.smsAuth.checkPassword({ request: { password: password } })
                        .then(getObject);
                })
            }
        },

        internalAds: {
            getPlaces: function() {
                return getClient().then(function(client) {
                    return client['internalads-places'].internalads_places_list()
                        .then(getObject);
                })
            },

            getProducts: function() {
                return getClient().then(function(client) {
                    return client['internalads-products'].getProductList();
                }).then(getObject)
            }
        }

    });

})();
