/**
 * prevent default for vertical mouse scroll
 *
 * If user scroll down in block with mixed wheel-prevent
 */
BEM.DOM.decl('i-wheel-prevent', null, {
    live: function() {
        this.liveBindTo('wheel', function(e) {
            var area = e.data.domElem.get(0),
                origEvent = e.originalEvent,
                delta = origEvent.deltaY || origEvent.detail || origEvent.wheelDelta;

            // element has no scroll
            if (area.scrollHeight <= area.clientHeight) {
                return true;
            }

            if (delta < 0 && area.scrollTop === 0) {
                e.preventDefault();
            }

            if (delta > 0 && area.scrollHeight - area.clientHeight - area.scrollTop <= 1) {
                e.preventDefault();
            }
        });

        return false;
    }
});
