/**
 * Формирование превью масштабированием: на основе оригинальной картинки и параметра scale:
 * @param {String} ctx.imageUrl url оригинала изображения
 * @param {String} [ctx.title] текстовое описание изображения
 * @param {Number} ctx.width ширина оригинала изображения
 * @param {Number} ctx.height высота оригинала изображения
 * @param {Number} ctx.scale коэффициент масштабирования превью
 * @param {String} [ctx.hintContent='+ Увеличить'] контент всплывающей позсказки всплывающей при наведении на превью
 **/
block('image-preview').mod('type', 'scale').elem('preview').def()(function() {

    return {
        block: 'image',
        mix: {
            block: 'image-preview',
            elem: 'preview'
        },
        url: this.ctx.imageUrl,
        alt: this.ctx.title ||
            (this.ctx.scale == 1 ? iget2('image-preview', 'otkryt-sayt-po-ssylke', 'Открыть сайт по ссылке') : iget2('image-preview', 'uvelichit', 'Увеличить')),
        width: this.ctx.width * this.ctx.scale,
        height: this.ctx.height * this.ctx.scale
    };
});
