/**
 * Формирование превью на основе url превью в параметрах:
 * @param {String} ctx.previewUrl url превью изображения
 * @param {String} ctx.imageUrl url оригинала изображения
 * @param {String} [ctx.clickUrl] url перехода по клику для ГО
 * @param {String} [ctx.title] текстовое описание изображения
 * @param {Number} ctx.width ширина оригинала изображения
 * @param {Number} ctx.height высота оригинала изображения
 * @param {Number} [ctx.previewWidth] ширина превью изображения
 * @param {Number} [ctx.previewHeight] высота превью изображения
 * @param {String} [ctx.hintContent='+ Увеличить'] контент всплывающей позсказки всплывающей при наведении на превью')
 **/

block('image-preview')(
    js()(function() {

        return {
            url: this.ctx.imageUrl,
            width: this.ctx.width,
            height: this.ctx.height,
            title: this.ctx.title,
            videoPreview: this.ctx.videoPreview,
            banner: this.ctx.banner,
            clickUrl: this.ctx.clickUrl
        };
    }),

    content()(function() {
        return [
            applyCtx(this.extend(this.ctx, { elem: 'preview' })),
            this.ctx.scale == 1 || {
                elem: 'hint',
                content: this.ctx.hintContent ?
                    this.ctx.hintContent :
                    [
                        {
                            elem: 'hint-icon',
                            content: '+'
                        },
                        iget2('image-preview', 'uvelichit', 'Увеличить')
                    ]
            }
        ];
    }),

    elem('preview').def()(function() {
        var imageBlock = {
            block: 'image',
            url: this.ctx.previewUrl,
            alt: this.ctx.title ||
                (this.ctx.scale == 1 ? iget2('image-preview', 'otkryt-sayt-po-ssylke', 'Открыть сайт по ссылке') : iget2('image-preview', 'uvelichit', 'Увеличить')),
            mix: {
                block: 'image-preview',
                elem: 'preview'
            }
        };

        this.ctx.previewWidth && (imageBlock.width = this.ctx.previewWidth);
        this.ctx.previewHeight && (imageBlock.height = this.ctx.previewHeight);

        return imageBlock;
    }),

    elem('hint-icon').tag()('span')
);
