BEM.DOM.decl('image-preview', {
    onSetMod: {
        js: function() {
            this.bindTo('hint', 'click', function(event) {
                event.preventDefault();

                this._showPopup();
            });
        }
    },

    /**
     * Показывает попап с оригиналом изображения
     * @private
     */
    _showPopup: function() {
        // что бы закрытие модального попапа с увеличенной картинкой не закрывало родительский попап
        var outsidePopup = this.findBlockOutside('popup');

        if (outsidePopup) {
            this._getPopup()
                .findBlockOn('popup')
                .setParent(outsidePopup);
        }

        if (this.params.videoPreview) {
            this
                ._getPopup()
                .setContent(BEMHTML.apply({
                    block: 'b-video-preview',
                    mix: {
                        block: 'image-preview',
                        elem: 'video-preview'
                    },
                    banner: this.params.banner,
                    width: this.params.width,
                    height: this.params.height,
                    autostart: true,
                    url: this.params.videoPreview,
                    clickUrl: this.params.clickUrl
                }))
                .on('hide', function(e) {
                    // Останавливаем видео после закрытия попапа
                    var videoPreview = e.block.findBlockInside('b-video-preview');

                    videoPreview && videoPreview.onDisable();
                })
                .on('show', function(e) {
                    var videoPreview = e.block.findBlockInside('b-video-preview');

                    videoPreview && videoPreview.onEnable();
                })
                .show();
        } else {
            this
                ._getPopup()
                .setContent(BEMHTML.apply({
                    block: 'image',
                    url: this.params.url,
                    width: this.params.width,
                    height: this.params.height,
                    alt: this.params.title || ''
                }))
                .show();
        }
    },

    /**
     * Возвращает блок попап для показа оригинала изображения
     * @returns {BEM}
     */
    _getPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({
            type: 'modal',
            position: 'fixed',
            'has-close': 'yes'
        },
            {},
            {
                content: {
                    block: 'image-preview',
                    elem: 'popup-content'
                }
            },
            {
                type: 'paranja'
            }));
    }
});
