BEM.DOM.decl({ block: 'indoor-map-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this._renderDnaComponent();
        }
    },

    _saveButton: null,

    _isChangedValue: null,

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!!this._isChangedValue);

        return deferred.promise();
    },

    /**
     * Преобразует данные из стейта компонента в серверные
     * @param {Object} data
     * @return {{selected: Array}}
     * @private
     */
    _provideData: function(data) {
        return data;
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._onSaveClick(e, data);
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSaveClick: function(e, data) {
        this._saveButton || (this._saveButton = e.block);

        this.trigger('save', this._provideData(this._currentValue));
    },

    /**
     * Возвращает инстанс кнопки "Сохранить"
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('save', 'button'));
    },

    /**
     * Возвращает инстанс прогнозатора
     * @private
     */
    _getPredictor: function() {
        return this._predictor = this.findBlockOn('predictor', {
            blockName: 'b-outdoor-predictor',
            modName: 'type',
            modVal: 'indoor'
        });
    },

    /**
     * Обработчик клика по любой кнопке "Отмена"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onCancelClick: function(e, data) {
        this.trigger('cancel');
    },

    /**
     * Возвращает все зоны экранов
     * @returns {Array} - наименования зон расположения экранов (String)
     * @private
     */
    _getAllZones: function() {
        var screenGroupsByRegion = this.params.screenGroupsByRegion,
            dictionary = this.params.dictionary,
            result = [];

        Object.keys(screenGroupsByRegion).map(function(regionId) {
            return screenGroupsByRegion[regionId].map(function(screenGroup) {
                result.push(dictionary.zone[screenGroup.zoneCategory]);
            });
        });

        return u._.uniq(result);
    },

    /**
     * Возвращает все категории экранов
     * @returns {Array} - наименования категорий экранов (String)
     * @private
     */
    _getAllCategories: function() {
        var screenGroupsByRegion = this.params.screenGroupsByRegion,
            dictionary = this.params.dictionary,
            result = [];

        Object.keys(screenGroupsByRegion).map(function(regionId) {
            return screenGroupsByRegion[regionId].map(function(screenGroup) {
                result.push(dictionary.facility[screenGroup.facilityType]);
            });
        });

        return u._.uniq(result);
    },

    _formatDataToResponse: function(selectedScreensByRegion) {
        var data = {
                campaign_id: this.params.campaign_id,
                page_blocks: [],
                page_blocks_region: []
            },
            screenGroupsByRegion = this.params.screenGroupsByRegion,
            params = this.params,
            allSelectedRegionPlatforms = [],
            groupId = params.adgroup_id,
            isNewGroup = params.isNewGroup,
            videoCreativeIds = params.video_creative_ids,
            pagesAndBlocksId = {};

        if (selectedScreensByRegion) {
            Object.keys(selectedScreensByRegion).map(function(region) {
                selectedScreensByRegion[region].map(function(screenGroupId) {
                    var splitVal = screenGroupId.split('-'),
                        pageId = splitVal[0];

                    pagesAndBlocksId[pageId] = (pagesAndBlocksId[pageId] || []);

                    screenGroupsByRegion[region].forEach(function(page) {
                        if (page.id === screenGroupId) {
                            var screensId = page.screens.map(function(screen) {
                                return screen.id.split('-')[1];
                            });

                            pagesAndBlocksId[pageId] = pagesAndBlocksId[pageId].concat(screensId);
                        }
                    });
                });
            });

            Object.keys(screenGroupsByRegion).map(function(regionId) {
                screenGroupsByRegion[regionId].forEach(function(screenGroup) {
                    var screensId = screenGroup.screens.map(function(screen) {
                            return screen.id.split('-')[1];
                        }),
                        splitVal = screenGroup.id.split('-'),
                        pageId = splitVal[0];

                    allSelectedRegionPlatforms[pageId] = (allSelectedRegionPlatforms[pageId] || []);
                    allSelectedRegionPlatforms[pageId] = allSelectedRegionPlatforms[pageId].concat(screensId);
                });
            });

            Object.keys(pagesAndBlocksId).map(function(page) {
                data.page_blocks.push({
                    block_ids: pagesAndBlocksId[page],
                    page_id: page
                })
            });

            Object.keys(allSelectedRegionPlatforms).map(function(page) {
                data.page_blocks_region.push({
                    block_ids: allSelectedRegionPlatforms[page],
                    page_id: page
                })
            });
        }

        if (!isNewGroup) {
            data.adgroup_id = groupId;
        }

        // TODO @ruzhansky - при создании группы, поле video_creative_ids инитится массив с элементом(пустая строка).
        if (videoCreativeIds && videoCreativeIds[0]) {
            data.video_creative_ids = videoCreativeIds;
        }

        return data;
    },

    _formatDataForSummary: function(selectedByRegion) {
        var regions = this.params.screenGroupsByRegion,
            dictionary = this.params.dictionary,
            allZones, allCategories,
            screensCount = 0,
            selectedScreensId = [],
            regionsId = [],
            regionsName = [],
            categories = [],
            zones = [];

        Object.keys(selectedByRegion).forEach(function(regionId) {
            var regionPlatforms = selectedByRegion[regionId];

            if (regionPlatforms.length) {
                regionsId.push(regionId);
            }

            selectedScreensId = selectedScreensId.concat(regionPlatforms);
        });

        Object.keys(regions).forEach(function(regionId) {
            regions[regionId].forEach(function(screenGroup) {
                if (regionsId.includes(screenGroup.regionId)) {
                    regionsName.push(dictionary.region[screenGroup.regionId].text);
                }

                if (selectedScreensId.includes(screenGroup.id)) {
                    zones.push(dictionary.zone[screenGroup.zoneCategory]);
                    categories.push(dictionary.facility[screenGroup.facilityType]);

                    screenGroup.screens.forEach(function(screen) {
                        screensCount += screen.screenWeight;
                    });
                }
            });
        });

        categories = u._.uniq(categories);
        zones = u._.uniq(zones);
        regionsName = u._.uniq(regionsName);

        allZones = this._getAllZones().filter(function(zone) {
            return !zones.includes(zone)
        });
        allCategories = this._getAllCategories().filter(function(category) {
            return !categories.includes(category)
        });

        if (!allZones.length) {
            zones = [iget2('indoor-map-popup', 'all', 'Все')];
        }

        if (!allCategories.length) {
            categories = [iget2('indoor-map-popup', 'all', 'Все')];
        }
        return {
            categories: categories.join(', '),
            zones: zones.join(', '),
            regions: regionsName.join(', '),
            platforms: screensCount
        };
    },
    /**
     * Обработчик изменения в попапе
     * @param {Object} state
     * @param {Object} state.data
     * @param {Boolean} state.isTargetingActive
     * @private
     */
    _onSettingsChange: function(state) {
        this._isChangedValue = true;
        this._currentValue = state;

        var predictorResponseData = this._formatDataToResponse(state),
            predictorSummary = this._formatDataForSummary(state),
            hierarchical_multipliers = u._.get(this.params.hierarchical_multipliers, 'demography_multiplier.conditions', []);

        predictorResponseData['bid_modifier_demographics_adjustments'] = hierarchical_multipliers;

        this._getPredictor().update(predictorResponseData, predictorSummary);

        var selectedScreensCount = u._.keys(state).reduce(function(count, regionId) {
            return count + state[regionId].length;
        }, 0);

        if (selectedScreensCount > 0) {
            this._getSaveButton().delMod('disabled');
        } else {
            this._getSaveButton().setMod('disabled', 'yes');
        }

        this.updatePreviewSelected(selectedScreensCount)
    },

    /**
     * Обновление количества выбранных щитов на карте
     * @param {Number} selectedCount - количество выбранных щитов
     */
    updatePreviewSelected: function(selectedCount) {
        if (selectedCount > 0) {
            BEM.DOM.update(this.elem('selected-preview'),
                iget2('indoor-map-popup', 'selected-platforms', 'Выбрано {platform}', {
                    platform: u.pluralize([
                        iget2('indoor-map-popup', 'one-platform', 'площадка'),
                        iget2('indoor-map-popup', 'some-platforms', 'площадки'),
                        iget2('indoor-map-popup', 'many-platforms', 'площадок')
                    ], selectedCount)
                })
            );
        } else {
            BEM.DOM.update(this.elem('selected-preview'), iget2('indoor-map-popup', 'no-one-selected', 'Площадок не выбрано'));
        }
    },

    /**
     * Render DNA component
     */
    _renderDnaComponent: function() {
        var dna = window.dna,
            screenGroupsByRegion = this.params.screenGroupsByRegion || {},
            dictionary = this.params.dictionary,
            selectedScreens = this.params.selectedScreens,
            regions,
            hierarchical_multipliers = u._.get(this.params.hierarchical_multipliers, 'demography_multiplier.conditions', []),
            predictorResponseData = this._formatDataToResponse(selectedScreens),
            selectedScreensCount = u._.keys(selectedScreens).reduce(function(count, regionId) {
                return count + selectedScreens[regionId].length;
            }, 0);

        regions = u._.keys(screenGroupsByRegion).map(function(regionId) {
            return {
                id: regionId,
                text: dictionary.region[regionId].text
            }
        });

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.DisplayMapProvider, {
                onChange: this._onSettingsChange.bind(this),
                mapType: 'indoor',
                regions: regions,
                dictionary: dictionary,
                screenGroupsByRegion: screenGroupsByRegion,
                selectedScreens: selectedScreens
            }, null), this.elem('settings')[0]);

        predictorResponseData['bid_modifier_demographics_adjustments'] = hierarchical_multipliers;

        this._getPredictor().update(
            predictorResponseData,
            this._formatDataForSummary(selectedScreens)
        );

        this.updatePreviewSelected(selectedScreensCount);
    },

    destruct: function() {
        window.dna.reactDOMUnmount(this.elem('settings')[0]);
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                this._onButtonClick(e, data);
            });

        return false;
    }

});
