(function($) {

    var defaultLimit = 15;

    BEM.decl({

        block: 'input__dataprovider_type_region-static',
        baseBlock: 'i-request_type_script'

    }, {

        onSetMod: {

            js: function() {

                this._lang = BEM.blocks['i-global'].param('locale');

            }

        },

        /**
         * Устанавливает новый родительский id для саджеста
         * Нужен для саджеста городов при выборе страны
         * @param {String} id родительского региона
         */
        updateParentId: function(id) {
            // если передавать 'default' то может получиться общий кеш между странами и городами DIRECT-43509
            this.params.cacheGroup = id || 'default-country';

        },

        /**
         * Метод фильтрации значений саджеста регионов
         * @param {Array} data Объект с данными для саджеста
         * @param {String} val Строка, введенная пользователем в саджест
         * @returns {Array} Массив отфильтрованных значений
         * @private
         */
        _filter: function(data, val) {

            var _this = this,
                cacheGroup = this.params.cacheGroup,
                re = new RegExp('^(' + u.escape.regExp(val.trim()) + ')', 'i'),
                limit = this.params.limit || defaultLimit,
                result = [];

            $.each(data, function(i, item) {

                var pid = item.parentId,
                    name = _this.getItemName(item);

                if (cacheGroup != 'default-country' && pid && pid != cacheGroup) return true;

                if (re.test(name)) {
                    var code = item.code || '';

                    result.push([
                        'region',
                        {
                            geoId: item.id,
                            val: name,
                            name: name.replace(re, '<strong>$1</strong>'),
                            phoneCode: code.split(' ')[0],
                            parentId: item.parentId
                        }
                    ]);
                }

                return result.length < limit;

            });

            return result;
        },

        /**
         * Возвращает имя элемента саджеста в зависимости от текущей локали
         * @param {Object} data данные элемента саджеста
         * @returns {String}
         */
        getItemName: function(data) {

            switch (this._lang) {
                case 'en':
                    return data.enname || data.name;
                case 'tr':
                    return data.trname || data.enname || data.name;
                case 'uk':
                    return data.ukname || data.name;
                default:
                    return data.name;
            }

        }

    });

})(jQuery);
