/**
 * Датапровайдер для саджестов страны и города
 */
BEM.decl({

    block: 'input__dataprovider_type_region',
    baseBlock: 'i-request_type_ajax'

}, {

    /**
     * Отправляет запрос на сервер
     * @param {String} request значение, введенное в инпут
     * @param {Function} callback колбек
     * @returns {__base|*}
     */
    get: function(request, callback) {

        if (!request) return;

        var type = this.params.data.type;

        return this.__base(
            {
                text: request.trim()
            },
            function(data) {
                if (data && data.length) {
                    callback.call(this, {
                        items: data.map(function(item) {
                            var parent = item.parent_name;
                            return [
                                'region',
                                {
                                    name: item.name + (type == 'city' && parent ? ' (' + parent + ')' : ''),
                                    val: item.name,
                                    phoneCode: item.phone_code,
                                    geoId: item.id
                                }
                            ];
                        })
                    });
                }
            });

    },

    /**
     * Устанавливает новый родительский id для саджеста
     * Нужен для саджеста городов при выборе страны
     * @param {String|Number} id родительского региона
     */
    updateParentId: function(id) {

        this.params.data.parent_id = id;
        this.params.cacheGroup = id;

    },

    /**
     * Возвращает параметры блока по умолчанию
     * @returns {extend|*}
     */
    getDefaultParams: function() {

        return $.extend(this.__base(), { data: {}, dataType: 'json' });

    }

});
