/**
 * Счетчик количества символов в значении инпута
 */
BEM.DOM.decl({

    block: 'input',
    elem: 'numerator'

}, {

    /**
     * Обновляет контент счетчика при изменении значения инпута
     * @param {String} val текущее значение инпута
     * @private
     */
    _update: function(val) {

        var value = this.params.value - val.length;

        this
            .toggleMod('exceed', 'yes', '', value < 0)
            .domElem.text(value);

    }

}, {

    live: function() {

        this.liveInitOnParentEvent(
            'change',
            function(e) {
                this._update(e.block.val());
            });

    }
});
