/**
 * При установке этого модификатора инпут будет генерировать событие выбора
 * значения из саджеста даже если выбора не было, но введенное в инпут значение
 * совпадает с одним из предложенных. Событие генерируется в момент потери
 * инпутом фокуса. Используется вместе с модификатором _suggest_yes и доопределяет его
 */
BEM.DOM.decl({

    block: 'input',
    modName: 'autoselect',
    modVal: 'yes'

}, {

    onSetMod: {

        js: function() {

            this.__base.apply(this, arguments);
            this.on('update-items', this._onUpdateItems);
        }

    },

    /**
     * Отправляет запрос
     */
    doRequest: function() {

        this._doRequest();

    },

    /**
     * Реакция на событие потери фокуса
     * @private
     */
    _onBlur: function() {

        this._selectMatchingItem();
        this.__base();

    },

    /**
     * Обработчик, вызываемый в момент выбора элемента из саджеста
     * @param {BEM} item Выбранный элемент
     * @private
     */
    _onSelectItem: function(item) {

        this._savedVal = item.val();
        this.__base.apply(this, arguments);

    },

    /**
     * Обработчик, вызываемый в момент потери фокуса инпута при наличии в нем значения,
     * совпадающего с одним из предложенных
     * Частичная копипаста нативного метода _onSelectItem без неиспользуемого в данном кейсе кода
     * @param {BEM} item Выбранный элемент
     * @private
     */
    _onSelectItemAuto: function(item) {

        this._savedVal = item.val();

        this._preventRequest = true;
        this
            .val(
            this._userVal = this._savedVal,
            { source: 'autocomplete', itemIndex: this._curItemIndex })
            ._getPopup().hide();

        this.afterCurrentEvent(function() {
            this.del('_preventRequest');
        });

        this.trigger('select', { item: item });

    },

    /**
     * Реакция на событие 'update-items'
     * @private
     */
    _onUpdateItems: function() {

        this.hasMod('focused', 'yes') || this._selectMatchingItem();

    },

    /**
     * Выбирает совпадающее с введенным значение из предложенных саджестом
     * @private
     */
    _selectMatchingItem: function() {

        var dataprovider = this.getDataprovider(),
            val = this.val().trim(),
            re = new RegExp('^' + u.escape.regExp(val) + '$', 'i'),

            items = this._items.filter(function(item) {
                return re.test(item.val());
            });

        if (items.length) {
            dataprovider.abort && dataprovider.abort();
            this._onSelectItemAuto(items[0]);
        } else {
            this._savedVal = val;
            this.trigger('select-unknown');
        }

    }

}, {});
