BEM.DOM.decl({ block: 'input', mod: 'counter', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.limit = this.params.limit;
            this.counter = this.elem('counter');

            if (this.params.lengthCounter) {
                this.countLength = BEM.create(this.params.lengthCounter).countLength;
            }

            this.on('change', this.updateCounter, this);
        }
    },

    updateCounter: function(e, data) {
        var valLength = this.countLength(this.val()),
            counterValue = this.limit ? this.limit - valLength : valLength;

        BEM.DOM.update(this.counter, counterValue);

        if (counterValue < 0 && this.limit) {
            this.setMod(this.counter, 'warn', 'yes');
            this._isLimitExceeded = true;
        } else {
            this.delMod(this.counter, 'warn');
            this._isLimitExceeded = false;
        }
    },

    setLimit: function(newLimit) {
        this.limit = newLimit;

        BEM.DOM.update(this.counter, this.limit);
        this.updateCounter();

        return this;
    },

    countLength: function(value) {
        return value ? value.length : 0;
    },

    isLimitExceeded: function() {
        return this._isLimitExceeded;
    }

});
