BEM.DOM.decl({ name: 'input', modName: 'suggest', modVal: 'yes' }, {

    /**
     * По заполненному в инпуте значению value пытается понять, какой элемент саджеста выбран. После этого триггерит событие о выбранном элементе
     * @returns {Promise}
     */
    doRequestOnValue: function() {
        var _this = this,
            deferred = $.Deferred();

        this._userVal = this.val();
        this
            .trigger('data-requested')
            .getDataprovider().get(
                _this.val(),
                function(data) {
                    _this.trigger('data-received', data);

                    var dataItems = data.items || data;

                    if (dataItems.length) {
                        //структура { params: dataItems[0][1]} нужна чтобы совпадало с данными, возвращаемыми b-autocomplete-item
                        _this.trigger('select', { item: { params: dataItems[0][1] } });
                        deferred.resolve()
                    }
                });

        return deferred.promise()

    }

});
