block('lang-switcher')(

    def()(function() {
        this.ctx.lang = {
            lang: this.data.lang,
            name: u['lang-switcher'].getLangName(this.data.lang)
        };

        this.retPath = this.ctx.retPath || encodeURIComponent(this['i-global'].retpath);

        return applyNext();
    }),

    content()(function() {
        var data = this.data,
            yaDomain = data.yandex_domain,
            global = this['i-global'],
            sk = global['secret-key'],
            retPath = this.ctx.retPath,
            langList;                           // коды регионов

        // также нужно править data/block/i-footer/i-footer.tt2
        switch (yaDomain) {
            case 'yandex.ru':
            case 'yandex.by':
            case 'yandex.kz':
            case 'yandex.com':
                langList = ['en', 'ru'];
                break;
            case 'yandex.ua':
                langList = ['ru', 'ua'];
                break;
            case 'yandex.com.tr':
                langList = ['en', 'tr'];
                break;
        }

        return langList.map(function(lang) {
            return {
                elem: 'lang',
                elemMods: { selected: lang == data.lang ? 'yes' : '' },
                lang: {
                    lang: lang,
                    name: u['lang-switcher'].getLangName(lang)
                },
                url: u['lang-switcher'].getUrl(lang, sk, retPath, global.tld)
            };
        }, this);
    })
);
