(function() {
    var langs = {
        ru: { name: 'Ru', code: 'ru' },
        en: { name: 'En', code: 'en' },
        ua: { name: 'Ua', code: 'uk' },
        tr: { name: 'Tr', code: 'tr' }
    };

    u.register({
        'lang-switcher': {

            /**
             * Получить название языка по коду региона
             * @param {String} lang - код региона
             */
            getLangName: function(lang) {
                return (langs[lang] || {}).name;
            },

            /**
             * Получить код языка по коду региона
             * @param {String} lang - код региона
             */
            getLangCode: function(lang) {
                return (langs[lang] || {}).code;
            },

            /**
             * Формирует URL для переключения языка
             * @param {String} lang - код региона
             * @param {String} sk - secret key
             * @param {String} retPath - retpath
             * @param {String} tld - домен 1-го уровня
             * @return {String}
             */
            getUrl: function(lang, sk, retPath, tld) {
                var langCode = u['lang-switcher'].getLangCode(lang),
                    query = {};

                if (sk) {
                    query = { intl: langCode, sk: sk };
                    retPath && (query.retpath = retPath);
                }

                return u.formatUrl({
                    protocol: 'https',
                    host: 'www.yandex.' + tld,
                    path: '/portal/set/lang/',
                    query: query
                });
            }
        }
    });
})();
