/**
 * Модификатор позволяет генерировать произвольные события при клике по ссылке
 * Имя события, которое нужно сгенерировать задается js-параметром eventName
 * Можно передать произвольные данные события в js-параметре eventData
 */
BEM.DOM.decl({

    block: 'link',
    modName: 'action',
    modVal: 'event'

}, {

    /**
     * Реакция на событие клика по ссылке
     * @param {Event} e объект события
     * @private
     */
    _onClick: function(e) {

        this.__base.apply(this, arguments);

        this.hasMod('disabled') || this.trigger(this.params.eventName, this.params.eventData);

    }

});
