BEM.DOM.decl({ name: 'link', modName: 'sample', modVal: 'yes' }, {
    /**
     * Обработчик события клика на ссылку
     * @param {Object} e
     * @private
     */
    _onClick: function(e) {

        e.preventDefault();

        this.hasMod('disabled', 'yes') || this.params && this.trigger('click', this.params.data);

    },

    /**
     * Устанавливает/возвращает значение параметра, присвоенного ссылке
     * @param {String} [value]
     * @returns {BEM}
     */
    val: function(value) {
        if (value === undefined) return this.params.data;

        this.params.data = value;

        return this;
    },

    /**
     * Изменяет текст ссылки
     * @param {String} value
     * @returns {BEM}
     */
    setText: function(value) {
        this.elem('inner').html(value);

        return this;
    }

}, {

    live: function() {

        this.__base.apply(this, arguments);

        this.liveBindTo({ modName: 'sample', modVal: 'yes' }, 'pointerclick', function(e) {
            this._onClick(e);
        });

    }

});
