describe('link_sample_yes', function() {
    var domTree,
        block;

    function createBlock(data, text) {
        domTree = u.getDOMTree({
            block: 'link',
            mods: { pseudo: 'yes', sample: 'yes' },
            js: { data: data },
            content: text
        });

        $('body').append(domTree);

        block = $(domTree).bem('link');
    }

    beforeEach(function() {
        createBlock('data', 'text');
    });

    afterEach(function() {
        block.destruct();
    });

    it('Функция val вызванная без аргумента должна возвращать значение, переданное в параметрах', function() {
        expect(block.val()).to.be.equal('data');
    });

    it('Функция val вызванная с аргументом должна перезаписывать значение, переданное в параметрах', function() {
        expect(block.val('new_data').val()).to.be.equal('new_data');
    });

    it('Функция setText должна изменять текст ссылки', function() {
        block.setText('new_text');
        expect(block.elem('inner').html()).to.be.equal('new_text');
    });

});
