BEM.DOM.decl({ block: 'link', modName: 'type', modVal: 'ajax' }, {
    onSetMod: {
        js: function() {
            this.states = this.params.states;
        }
    },

    /**
     * Отсылает ajax-запрос на сервер
     * @param {Object} e
     * @private
     */
    _sendAjax: function(e) {
        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            cache: false,
            callbackCtx: this,
            dataType: 'json'
        }).get(
            this.states[this.getMod('state')].data,
            this._onRequestSuccess,
            function() { }
        );

        return false;
    },

    /**
     * Запрос успешно завершился
     * @returns {BEM}
     * @private
     */
    _onRequestSuccess: function() {
        var newState = this.getMod('state') == 0 ? 1 : 0;

        this.setMod('state', newState);
        this.elem('inner').text(this.states[newState].text);

        return this;
    }
}, {

    live: function() {
        this.__base.apply(this, arguments);

        this.liveBindTo({ modName: 'type', modVal: 'ajax' }, 'click', function(e) { return this._sendAjax(e); });

    }
});
