BEM.MODEL.decl('m-adjustment-base-rate', {
    modelId: {
        type: 'id',
        internal: true
    },
    //модель является моделью групповых контроллов
    isCommon: {
        type: 'boolean',
        internal: true
    },

    min: {
        type: 'number',
        default: 0
    },
    default_multiplier: {
        type: 'number',
        default: 100
    },
    pct_max: 'number',
    pct_min: 'number',

    sign: {
        type: 'enum',
        enum: ['increment', 'decrement', ''],
        default: 'increment' // decrement
    },
    max: {
        type: 'number',
        dependsFrom: ['sign', 'pct_min', 'pct_max', 'default_multiplier'],
        calculate: function() {
            return this.get('sign') === 'increment' ?
                this.get('pct_max') - this.get('default_multiplier') :
                this.get('default_multiplier') - this.get('pct_min');
        }
    },
    inputHint: {
        type: 'string',
        dependsFrom: 'max',
        calculate: function(max) {
            return !this.get('sign') ? '' : iget2('m-adjustment-base-rate', 'max-s', 'max {foo}', {
                foo: max
            });
        }
    },
    input: {
        type: 'blank-number2',
        precision: 0,
        default: '',
        validation: {
            rules: {
                gte: {
                    needToValidate: function(value) {
                        //@heliarian если в групповом селекте "-", то групповой инпут проверять не надо
                        return !(this.get('isCommon') && !this.get('sign'));
                    },
                    value: function() {
                        return this.get('max');
                    },
                    text: function() {
                        return this.get('sign') == 'increment' ?
                            iget2('m-adjustment-base-rate', 'nelzya-uvelichit-stavku-bolee', 'Нельзя увеличить ставку более чем на {foo}%', {
                                foo: this.get('max')
                            }) :
                            iget2('m-adjustment-base-rate', 'nelzya-umenshit-stavku-bolee', 'Нельзя уменьшить ставку более чем на {foo}%', {
                                foo: this.get('max')
                            });
                    }
                },
                //@heliarian - кажется достаточно проверять просто на пустоту
                //поле, приведенное к типу number с округлением всегда будет либо пустым, либо целым и положительным
                integerAndPositive: {
                    needToValidate: function() {
                        //для групповых контроллов не надо проверять поле на пустоту
                        return !this.get('isCommon');
                    },
                    validate: function(value) {
                        return value !== '' && value >= 0 && (value - this.get('min')) % 1 === 0;
                    },
                    text: iget2('m-adjustment-base-rate', 'znachenie-dolzhno-byt-celym', 'Значение должно быть целым положительным числом')
                }
            }
        }
    },
    coefficient: {
        type: 'number',
        dependsFrom: ['sign', 'input'],
        calculate: function(fields) {
            var input = (Number(fields.input)).valueOf();

            return fields.sign == 'increment' ?
                (this.get('default_multiplier') + input) :
                (this.get('default_multiplier') - input)
        }
    }
}, {

});
