BEM.MODEL.decl({ model: 'm-adjustment-cpm-group-type-rate', baseModel: 'm-adjustment-base-rate' }, {

    type: {
        type: 'enum',
        // u.consts('INVENTORY_MULTIPLIER_TYPES') + u.consts('BANNER_TYPE_MULTIPLIER_TYPES')
        enum: ['instream_web', 'inpage', 'interstitial', 'inbanner', 'rewarded', 'cpm_banner']
    },

    textType: {
        type: 'string',
        dependsFrom: ['type'],
        calculate: function(type) {
            return u['b-rates-chooser'].cpmGroupType.getText(type);
        }
    },

    banners_pct_min: {
        type: 'number',
        internal: true
    },

    banners_pct_max: {
        type: 'number',
        internal: true
    },

    inventory_pct_min: {
        type: 'number',
        internal: true
    },

    inventory_pct_max: {
        type: 'number',
        internal: true
    },

    pct_max: {
        type: 'number',
        dependsFrom: ['type', 'banners_pct_max', 'inventory_pct_max'],
        calculate: function() {
            return this.get('type') === 'cpm_banner' ? this.get('banners_pct_max') : this.get('inventory_pct_max');
        }
    },

    pct_min: {
        type: 'number',
        dependsFrom: ['type', 'banners_pct_min', 'inventory_pct_min'],
        calculate: function() {
            return this.get('type') === 'cpm_banner' ? this.get('banners_pct_min') : this.get('inventory_pct_min');
        }
    }

});
