BEM.MODEL.decl('m-adjustment-cpm-group-type-rates', {
    modelId: {
        type: 'id',
        internal: true
    },

    isEnabled: {
        type: 'boolean',
        default: true
    },

    //модель, отвечающая за групповое редактирование корректировок
    common_control: {
        type: 'model',
        modelName: 'm-adjustment-cpm-group-type-rate'
    },

    choosedTypes: {
        type: 'array',
        internal: true,
        dependsFrom: ['rates'],
        calculate: function(rates) {
            return rates.map(function(rate) {
                return rate.get('type');
            });
        }
    },

    bannersMaxConditions: {
        type: 'number'
    },

    inventoryMaxConditions: {
        type: 'number'
    },

    max_conditions: {
        type: 'number',
        dependsFrom: ['bannersMaxConditions', 'inventoryMaxConditions'],
        calculate: function() {
            return this.get('bannersMaxConditions') + this.get('inventoryMaxConditions')
        }
    },

    rates: {
        type: 'models-list',
        modelName: 'm-adjustment-cpm-group-type-rate',
        validation: {
            rules: {
                crossing: {
                    validate: function() {
                        return !this.get('crossErrors');
                    }
                },
                deep: true
            }
        }
    },

    crossErrors: {
        type: 'string',
        dependsFrom: ['rates'],
        calculate: function() {
            return this._buildCrossingErrors();
        }
    }

}, {

    _buildCrossingErrors: function() {
        var rates = this.get('rates', 'raw'),
            isAllChoosed = !u._.xor(
                u['b-rates-chooser'].cpmGroupType.getRateTypes(),
                rates.map(function(rate) { return rate.get('type') })
            ).length,
            allRatesAreDecreasing = rates.every(function(rate) { return !rate.get('coefficient') });

        return isAllChoosed && allRatesAreDecreasing ?
            iget2(
                'm-adjustment-cpm-group-type-rates',
                'all-rates-are-decreasing',
                'Нельзя устанавливать корректировку -100% на все типы инвентаря'
            ) :
            '';
    }

});
