BEM.MODEL.decl('m-adjustment-demography-rates', {

    modelId: {
        type: 'id',
        internal: true
    },

    rates: {
        type: 'models-list',
        modelName: 'm-adjustment-demography-rate',
        validation: {
            rules: {
                crossing: {
                    validate: function() {
                        return !this.get('crossErrors');
                    }
                },
                genderAge: {
                    validate: function() {
                        return !this.get('genderAgeErrors');
                    }
                },
                deep: true
            }
        }
    },

    genderAgeErrors: {
        type: 'string',
        dependsFrom: ['rates'],
        calculate: function() {
            return this._buildGenderAgeErrors();
        }
    },

    crossErrors: {
        type: 'string',
        dependsFrom: ['rates'],
        calculate: function() {
            return this._buildCrossingErrors();
        }
    },

    //Можем менять поле sign в любой из корректировок
    canChangeSign: 'boolean',

    max_conditions: 'number',

    isEnabled: {
        type: 'boolean',
        default: true
    },

    //модель, отвечающая за групповое редактирование корректировок
    common_control: {
        type: 'model',
        modelName: 'm-adjustment-base-rate'
    },

    mediaType: {
        type: 'string',
        value: {}
    }
}, {

    _buildCrossingErrors: function() {
        var errors = this._buildCrossingArray(),
            errorsTexts;

        errorsTexts = errors.map(function(err) {
            return err.join(', ');
        });

        errorsTexts = u._.xor(errorsTexts);

        return errorsTexts.map(function(err) {
            return iget2(
                'm-adjustment-demography-rates',
                'peresekayutsya-usloviya-no-s',
                'Пересекаются условия № {foo}. Удалите одно из них или измените настройки.',
                {
                    foo: err
                }
            );
        }).join('<br/>');
    },

    _buildCrossingArray: function() {
        var rates = this.get('rates').map(function(r) { return r.toJSON() }),
            cross = {},
            isValid = true,
            crossArr = [];

        rates.forEach(function(rate, i) {
            var gender = rate.gender,
                age = rate.age,
                itemIndex = i + 1;

            if (age.length && rate.gender.length) {
                if (!cross[age]) {
                    cross[age] = {
                        male: [],
                        female: []
                    };
                }

                if (gender === 'all') {
                    cross[age]['male'].push(itemIndex);
                    cross[age]['female'].push(itemIndex);
                } else {
                    cross[age][gender].push(itemIndex);
                }
            }
        });

        if (cross['all']) {
            Object.keys(cross).forEach(function(age) {
                if (age !== 'all') {
                    cross[age]['male'] = cross[age]['male'].concat(cross['all'].male).sort();
                    cross[age]['female'] = cross[age]['female'].concat(cross['all'].female).sort();
                }
            });
        }

        Object.keys(cross).forEach(function(age) {
            if (cross[age]['male'].length >= 2) {
                isValid = false;
                crossArr.push(cross[age]['male']);
            }

            if (cross[age]['female'].length >= 2) {
                isValid = false;
                crossArr.push(cross[age]['female']);
            }
        });

        return crossArr;
    },

    _buildGenderAgeArray: function() {
        var rates = this.get('rates').map(function(r) { return r.toJSON() }),
            errArr = [];

        rates.forEach(function(rate, i) {
            var itemIndex = i + 1;

            if (!rate.age || !rate.gender) {
                errArr.push(itemIndex);
            }
        });

        return errArr;
    },

    _buildGenderAgeErrors: function() {
        var errors = this._buildGenderAgeArray(),
            errorText = errors.length === 1 ?
                iget2('m-adjustment-demography-rates', 'v-uslovii-no-s', 'В условии № {foo} отсутствуют пол или возраст', {
                    foo: errors.toString()
                }) :
                iget2('m-adjustment-demography-rates', 'v-usloviyah-no-s', 'В условиях № {foo} отсутствуют пол или возраст', {
                    foo: errors.join(', ')
                }) ;

        return errors.length ? errorText : '';
    }

});
