BEM.MODEL.decl({ model: 'm-adjustment-devices-rate', baseModel: 'm-adjustment-base-rate' }, {

    device: {
        type: 'enum',
        enum: u['b-adjustment-device-chooser'].getTypes()
    },

    deviceName: {
        type: 'string',
        dependsFrom: ['device'],
        calculate: function(device) {
            return u['b-adjustment-device-chooser'].getName(device) || '';
        }
    },

    isMobile: {
        type: 'boolean',
        dependsFrom: ['device'],
        calculate: function(device) {
            return u._.includes(u['b-adjustment-device-chooser'].getMobileTypes(), device)
        }
    },

    isMobileSwitchOffEnabled: 'boolean',

    mobile_pct_min: {
        type: 'number',
        internal: true
    },

    mobile_pct_max: {
        type: 'number',
        internal: true
    },

    desktop_pct_min: {
        type: 'number',
        internal: true
    },

    desktop_pct_max: {
        type: 'number',
        internal: true
    },

    pct_max: {
        type: 'number',
        dependsFrom: ['isMobile', 'mobile_pct_max', 'desktop_pct_max'],
        calculate: function() {
            return this.get('isMobile') ? this.get('mobile_pct_max') : this.get('desktop_pct_max');
        }
    },

    pct_min: {
        type: 'number',
        dependsFrom: ['isMobile', 'mobile_pct_min', 'desktop_pct_min', 'device'],
        calculate: function() {
            var ALL_MOBILE_RESTRICTED_VALUE = 50;

            if (!this.get('isMobile') || this.get('isCommon')) {
                return this.get('desktop_pct_min');
            }

            if (!this.get('isMobileSwitchOffEnabled') &&
                this.get('device') === 'all_mobile') {
                return ALL_MOBILE_RESTRICTED_VALUE;
            } else {
                return this.get('mobile_pct_min');
            }
        }
    }

});
