BEM.MODEL.decl('m-adjustment-devices-rates', {
    modelId: {
        type: 'id',
        internal: true
    },

    isEnabled: {
        type: 'boolean',
        default: true
    },

    //модель, отвечающая за групповое редактирование корректировок
    common_control: {
        type: 'model',
        modelName: 'm-adjustment-devices-rate'
    },

    choosedDevices: {
        type: 'array',
        internal: true,
        dependsFrom: ['rates'],
        calculate: function(rates) {
            return rates.map(function(rate) {
                return rate.get('device');
            });
        }
    },

    isMobileSwitchOffEnabled: 'boolean',

    rates: {
        type: 'models-list',
        modelName: 'm-adjustment-devices-rate',
        validation: {
            rules: {
                crossing: {
                    validate: function() {
                        return !this.get('crossErrors');
                    }
                },
                deep: true
            }
        }
    },

    max_conditions: {
        type: 'number',
        default: 2
    },

    crossErrors: {
        type: 'string',
        dependsFrom: ['rates'],
        calculate: function() {
            return this._buildCrossingErrors();
        }
    }

}, {

    _buildCrossingErrors: function() {
        var rates = this.get('rates', 'raw'),
            isAllDevicesChoosed = !u._.xor(
                ['all_mobile', 'desktop'],
                rates.map(function(rate) { return rate.get('device') })
            ).length,
            allRatesAreDecreasing = rates.every(function(rate) { return !rate.get('coefficient') });

        return isAllDevicesChoosed && allRatesAreDecreasing ?
            iget2(
                'm-adjustment-devices-rates',
                'all-rates-are-decreasing',
                'Нельзя устанавливать корректировку -100% на все устройства'
            ) :
            '';
    }

});
