BEM.MODEL.decl('m-adjustment-rates', {

    mobile: {
        type: 'model',
        modelName: 'm-adjustment-mobile-rate',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    video: {
        type: 'model',
        modelName: 'm-adjustment-video-rate',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    demography: {
        type: 'model',
        modelName: 'm-adjustment-demography-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    retargeting: {
        type: 'model',
        modelName: 'm-adjustment-retargeting-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    'performance-tgo': {
        type: 'model',
        modelName: 'm-adjustment-performance-tgo-rate',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    devices: {
        type: 'model',
        modelName: 'm-adjustment-devices-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    'cpm-group-type': {
        type: 'model',
        modelName: 'm-adjustment-cpm-group-type-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    weather: {
        type: 'model',
        modelName: 'm-adjustment-weather-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    },

    'traffic-jam': {
        type: 'model',
        modelName: 'm-adjustment-traffic-jam-rates',
        validation: {
            rules: {
                deep: true
            }
        }
    }

}, {

    provideData: function() {
        var modelData = this.toJSON(),
            data = {};

        if (modelData.retargeting.rates.length) {
            var retargetingData = {
                is_enabled: modelData.retargeting.isEnabled ? 1 : 0,
                conditions: {}
            };

            modelData.retargeting.rates.forEach(function(rate) {
                retargetingData.conditions[rate.retargetingId] = {
                    multiplier_pct: rate.coefficient
                };
            });

            data.retargeting_multiplier = retargetingData;
        }

        if (modelData.demography.rates.length) {
            data.demography_multiplier = {
                is_enabled: modelData.demography.isEnabled ? 1 : 0,
                conditions: modelData.demography.rates.map(function(rate) {
                    return {
                        age: rate.age,
                        gender: rate.gender,
                        multiplier_pct: rate.coefficient
                    };
                })
            };
        }

        if (modelData.video.isEnabled) {
            data.video_multiplier = {
                multiplier_pct: modelData.video.coefficient
            };
        }

        if (modelData['performance-tgo'].isEnabled) {
            data.performance_tgo_multiplier = {
                multiplier_pct: modelData['performance-tgo'].coefficient
            };
        }

        if (modelData.mobile.isEnabled) {
            data.mobile_multiplier = {
                multiplier_pct: modelData.mobile.coefficient
            };
        } else if (modelData.devices.isEnabled && modelData.devices.rates.length) {
            var mobile = u._.find(modelData.devices.rates, { isMobile: true }),
                desktop = u._.find(modelData.devices.rates, { device: 'desktop' });

            if (mobile) {
                data.mobile_multiplier = {
                    multiplier_pct: mobile.coefficient
                };

                if (u._.includes(['ios', 'android'], mobile.device)) {
                    data.mobile_multiplier.os_type = mobile.device;
                }
            }

            if (desktop) {
                data.desktop_multiplier = {
                    multiplier_pct: desktop.coefficient
                }
            }
        }

        if (modelData['cpm-group-type'].isEnabled && modelData['cpm-group-type'].rates.length) {
            var groupedRates = u._.groupBy(
                modelData['cpm-group-type'].rates,
                function(rate) {
                    return u['b-rates-chooser'].cpmGroupType.getGroupIdByRateType(rate.type)
                }
            );

            if (groupedRates.banners) {
                data.banner_type_multiplier = {
                    is_enabled: 1,
                    conditions: groupedRates.banners.map(function(rate) {
                        return { multiplier_type: rate.type, multiplier_pct: rate.coefficient };
                    })
                }
            }

            if (groupedRates.inventory) {
                data.inventory_multiplier = {
                    is_enabled: 1,
                    conditions: groupedRates.inventory.map(function(rate) {
                        return { multiplier_type: rate.type, multiplier_pct: rate.coefficient };
                    })
                }
            }
        }

        if (modelData.weather.rates.length) {
            data.weather_multiplier = {
                is_enabled: 1,
                conditions: u['i-adjustment-rates-data'].weatherToCNF(modelData.weather)
            };
        }

        if (modelData['traffic-jam'] && (modelData['traffic-jam'].rates || []).length) {
            data.expression_multipliers = [].concat({
                is_enabled: 1,
                type: 'express_traffic_multiplier',
                adjustments: modelData['traffic-jam'].rates.map(function(rate) {
                    return {
                        multiplier_pct: rate.coefficient,
                        condition: [[{ operation: 'eq', parameter: 'traffic-jam', value: rate.value }]]
                    }
                })
            })
        }

        return data;
    }
});
