BEM.MODEL.decl('m-adjustment-traffic-jam-rates', {

    modelId: {
        type: 'id',
        internal: true
    },

    isEnabled: {
        type: 'boolean',
        default: true
    },

    //модель, отвечающая за групповое редактирование корректировок
    common_control: {
        type: 'model',
        modelName: 'm-adjustment-traffic-jam-rate'
    },

    max_conditions: {
        type: 'number',
        default: 4
    },

    rates: {
        type: 'models-list',
        modelName: 'm-adjustment-traffic-jam-rate',
        validation: {
            rules: {
                crossing: {
                    validate: function() {
                        return !this.get('crossErrors');
                    }
                },
                deep: true
            }
        }
    },

    choosedValues: {
        type: 'array',
        internal: true,
        dependsFrom: ['rates'],
        calculate: function(rates) {
            return rates.map(function(rate) {
                return rate.get('value');
            });
        }
    },

    crossErrors: {
        type: 'string',
        dependsFrom: ['rates'],
        calculate: function() {
            return this._buildCrossingErrors();
        }
    }

}, {

    _buildCrossingErrors: function() {
        var rates = this.get('rates', 'raw'),
            isAllChoosed = !u._.xor(
                u['b-rates-chooser'].trafficJam.getValues(),
                rates.map(function(rate) { return rate.get('value') })
            ).length,
            allRatesAreDecreasing = rates.every(function(rate) { return !rate.get('coefficient') });

        return isAllChoosed && allRatesAreDecreasing ?
            iget2(
                'm-adjustment-cpm-group-type-rates',
                'all-traffic-jam-rates-are-decreasing',
                'Нельзя устанавливать корректировку -100% на все типы дорожных ситуаций'
            ) :
            '';
    }

});
