BEM.MODEL.decl({ model: 'm-adjustment-video-rate', baseModel: 'm-adjustment-base-rate' }, {
    isEnabled: {
        type: 'boolean',
        default: true,
        dependsFrom: 'input',
        calculate: function(input) {
            return !!input || input === 0;
        }
    },
    input: {
        type: 'blank-number2',
        precision: 0,
        validation: {
            rules: {
                gte: {
                    needToValidate: function(value) {
                        //@heliarian если в групповом селекте "-", то групповой инпут проверять не надо
                        return !(this.get('isCommon') && !this.get('sign'));
                    },
                    value: function() {
                        return this.get('max');
                    },
                    text: function() {
                        return this.get('sign') == 'increment' ?
                            iget2('m-adjustment-video-rate', 'nelzya-uvelichit-stavku-bolee', 'Нельзя увеличить ставку более чем на {foo}%', {
                                foo: this.get('max')
                            }) :
                            iget2('m-adjustment-video-rate', 'nelzya-umenshit-stavku-bolee', 'Нельзя уменьшить ставку более чем на {foo}%', {
                                foo: this.get('max')
                            });
                    }
                },
                integerAndPositive: {
                    validate: function(value) {
                        var isReal = value >= 0 && (value - this.get('min')) % 1 === 0,
                            isEmpty = typeof value === 'undefined';

                        return isEmpty || isReal;
                    },
                    text: iget2('m-adjustment-video-rate', 'znachenie-dolzhno-byt-celym', 'Значение должно быть целым положительным числом')
                }
            }
        }
    },

    mediaType: {
        type: 'string',
        value: {}
    }
});
