BEM.MODEL.decl({ model: 'm-adjustment-weather-rate', baseModel: 'm-adjustment-base-rate' }, {

    modelId: {
        type: 'id',
        internal: true
    },

    parameter: {
        type: 'enum',
        enum: [
            'temp',
            'cloudness',
            // 'prec_type',
            'prec_strength'
        ],
        format: function(parameter) {
            return u['b-rates-chooser'].weather.getParameterText(parameter);
        }
    },

    values: {
        type: 'array',
        format: function(values) {
            var parameter = this.model.get('parameter');

            return values.length ?
                values
                    .map(function(value) {
                        return u['b-rates-chooser'].weather.getParameterValueText(parameter, value);
                    })
                    .join(', ') :
                iget2('b-rates-chooser', 'empty_value','Не выбрано')
        }
    },

    valuesEnum: {
        type: 'array'
    },

    ge: {
        type: 'number',
        default: -50,
        precision: 0,
        preprocess: function(val) {
            if (val > 50) {
                return 50;
            } else if (val < -50) {
                return -50;
            } else {
                return +val;
            }
        }
    },

    le: {
        type: 'number',
        default: 50,
        precision: 0,
        preprocess: function(val) {
            if (val > 50) {
                return 50;
            } else if (val < -50) {
                return -50;
            } else {
                return +val;
            }
        }
    },

    // Переопредления для того чтобы отключить валидации при объединении условий по "И"
    input: {
        type: 'blank-number2',
        precision: 0,
        default: '',
        validation: {
            rules: {
                gte: {
                    needToValidate: function(value) {
                        //@heliarian если в групповом селекте "-", то групповой инпут проверять не надо
                        return this.getParentModel().get('setType') === 'and' ?
                            false :
                            !(this.get('isCommon') && !this.get('sign'));
                    },
                    value: function() {
                        return this.get('max');
                    },
                    text: function() {
                        return this.get('sign') === 'increment' ?
                            iget2(
                                'm-adjustment-weather-rate',
                                'nelzya-uvelichit-stavku-bolee',
                                'Нельзя увеличить ставку более чем на {foo}%',
                                { foo: this.get('max') }) :
                            iget2(
                                'm-adjustment-weather-rate',
                                'nelzya-umenshit-stavku-bolee',
                                'Нельзя уменьшить ставку более чем на {foo}%',
                                { foo: this.get('max') }
                            );
                    }
                },
                //@heliarian - кажется достаточно проверять просто на пустоту
                //поле, приведенное к типу number с округлением всегда будет либо пустым, либо целым и положительным
                integerAndPositive: {
                    needToValidate: function() {
                        //для групповых контроллов не надо проверять поле на пустоту
                        return this.getParentModel().get('setType') === 'and' ?
                            false :
                            !this.get('isCommon');
                    },
                    validate: function(value) {
                        return value !== '' && value >= 0 && (value - this.get('min')) % 1 === 0;
                    },
                    text: iget2(
                        'm-adjustment-weather-rate',
                        'znachenie-dolzhno-byt-celym',
                        'Значение должно быть целым положительным числом'
                    )
                }
            }
        }
    }

});
