BEM.MODEL.decl({ model: 'm-adjustment-weather-rates' }, {

    modelId: {
        type: 'id',
        internal: true
    },

    isEnabled: {
        type: 'boolean',
        default: true
    },

    setType: {
        type: 'enum',
        enum: ['and', 'or']
    },

    usedParameters: {
        type: 'array',
        internal: true,
        dependsFrom: ['rates'],
        calculate: function(rates) {
            return rates.map(function(rate) {
                return rate.get('parameter');
            });
        }
    },

    max_conditions: 'number',

    rates: {
        type: 'models-list',
        modelName: 'm-adjustment-weather-rate',
        validation: {
            rules: {
                crossing: {
                    validate: function() {
                        return !this.get('crossErrors');
                    }
                },
                deep: true
            }
        }
    },

    crossErrors: {
        type: 'string',
        dependsFrom: ['rates', 'setType'],
        calculate: function() {
            return this._buildCrossingErrors();
        }
    },

    //модель, отвечающая за групповое редактирование корректировок
    common_control: {
        type: 'model',
        modelName: 'm-adjustment-base-rate',
        validation: {
            rules: { deep: true },
            needToValidate: function() {
                return this.get('setType') === 'and';
            }
        }
    }

}, {

    _buildCrossingErrors: function() {
        var isSetTypeAND = this.get('setType') === 'and',
            rates = this.get('rates', 'raw') || [];

        return isSetTypeAND ?
            this._getCrossingParameters(rates)
                .map(function(item) {
                    return iget2(
                        'm-adjustment-weather-rates',
                        'and-error',
                        'Условия {condition} не могут быть выполнены одновременно, уберите или замените их.',
                        {
                            condition: item.indexes
                                .map(function(index) { return index + 1 })
                                .join(', ')
                        }
                    );
                })
                .join('<br>') :
            this._getCrossingParameterValues(rates)
                .map(function(item) {
                    return iget2(
                        'm-adjustment-weather-rates',
                        'or-error',
                        'Значения в условиях {condition} пересекаются, уберите или замените их.',
                        {
                            condition: item.indexes
                                .map(function(index) { return index + 1 })
                                .join(', ')
                        }
                    );
                })
                .join('<br>');
    },

    _getCrossingParameters: function(rates) {
        var groupedObj = rates.reduce(function(res, rate, index) {
            var parameter = rate.get('parameter');

            res[parameter] = (res[parameter] || []).concat({
                index: index,
                rate: rate
            });

            return res;
        }, {});

        return u._.reduce(groupedObj, function(result, items, parameter) {
            if (items.length > 1) {
                var indexes = [],
                    values = [];

                items.forEach(function(item) {
                    var rate = item.rate;

                    indexes.push(item.index);
                    values.push(parameter === 'temp' ?
                        u._.range(
                            Math.min(rate.get('le'), rate.get('ge')),
                            Math.max(rate.get('le'), rate.get('ge')) + 1
                        ) :
                        rate.get('values', 'raw'))
                });

                result.push({
                    parameter: parameter,
                    indexes: indexes,
                    values: values
                });
            }

            return result;
        }, [])
    },

    _getCrossingParameterValues: function(rates) {
        return this._getCrossingParameters(rates)
            .map(function(item) {
                var groupValues = item.values,
                    uniqValues = u._.uniq(u._.flatten(groupValues)),
                    conflictValues = u._.reduce(
                        uniqValues.reduce(function(result, uniqValue) {
                            result[uniqValue] = groupValues.reduce(function(res, values) {
                                return res += values.includes(uniqValue)
                            }, 0);

                            return result;
                        }, {}),
                        function(res, count, value) {
                            if (count > 1) {
                                res.push(Number(value))
                            }

                            return res;
                        },
                        []
                    ),
                    conflictIndexes = groupValues.reduce(function(result, values, i) {
                        if (u._.intersection(conflictValues, values).length) {
                            result.push(item.indexes[i])
                        }

                        return result;
                    }, []);

                return {
                    parameter: item.parameter,
                    indexes: conflictIndexes
                };
            })
            .filter(function(item) { return item.indexes.length })
    }

});
