BEM.MODEL.decl('m-agency-client-form', {
    firstname: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('m-agency-client-form', 'pozhaluysta-ukazhite-vashe-imya', 'Пожалуйста, укажите ваше имя.') }
            }
        }
    },
    lastname: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('m-agency-client-form', 'pozhaluysta-ukazhite-vashu-familiyu', 'Пожалуйста, укажите вашу фамилию.') }
            }
        }
    },
    login: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('m-agency-client-form', 'vyberite-login', 'Выберите логин.') },
                pattern: {
                    needToValidate: function(value) {
                        return !!value;
                    },
                    validate: function(value) {
                        return /^([a-zA-Z][a-zA-Z0-9.-]*[a-zA-Z0-9])$|^[a-zA-Z]$/g.test(value) && !/--/.test(value);
                    },
                    text: function() { return this.getLoginInvalidText() }
                }
            }
        }
    },
    password: {
        type: 'space-string',
        validation: {
            rules: {
                required: { text: iget2('m-agency-client-form', 'vyberite-parol', 'Выберите пароль.') },
                isLogin: {
                    text: iget2('m-agency-client-form', 'parol-ne-mozhet-sovpadat', 'пароль не может совпадать с логином.'),

                    validate: function(value) {
                        return this.get('login') !== value;
                    }
                },
                isWeek: {
                    text: function() {
                        return iget2('m-agency-client-form', 'slishkom-prostoy-s', 'слишком простой, {foo}', {
                            foo: this.getPasswordLength(true)
                        });
                    },

                    validate: function() {
                        return this.get('passwordState') !== 'error-weak';
                    }
                },
                badKeys: {
                    text: iget2('m-agency-client-form', 'nedopustimyy-simvol-v-parole', 'недопустимый символ в пароле.'),
                    validate: function(value) {
                        // если символ не присутствует в диапазоне разрешенных символов из таблицы ASCII в HEX,
                        // то пароль не валидный
                        return !/.*([^\x21-\x26\x28-\x7D])/.test(value);
                    }
                },
                minLength: {
                    text: function() {
                        return iget2('m-agency-client-form', 'slishkom-korotkiy-s', 'слишком короткий, {foo}', {
                            foo: this.getPasswordLength(true)
                        });
                    },
                    value: 6,
                    validate: function(curValue, ruleValue) {
                        var len = (curValue || '').length;

                        return !len || len >= ruleValue ;
                    }
                }
            }
        }
    },
    password2: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    validate: function() {
                        return this.isEmpty('password') || !this.isEmpty('password2');
                    },
                    text: iget2('m-agency-client-form', 'podtverdite-parol', 'Подтвердите пароль.')
                },
                match: {
                    validate: function(value) {
                        var password = this.get('password');

                        return !password || value === password;
                    },
                    text: iget2('m-agency-client-form', 'paroli-ne-sovpadayut', 'пароли не совпадают')
                }
            }
        }
    },
    captchaCode: {
        type: 'string',
        validation: {
            rules: {
                required: { text: iget2('m-agency-client-form', 'neobhodimo-vvesti-simvoly-s', 'Необходимо ввести символы с картинки.'), value: true }
            }
        }
    },
    trackId: 'string',
    firstnameError: 'string',
    lastnameError: 'string',
    loginError: 'string',
    passwordError: 'string',
    passwordRequiredError: 'string',
    password2Error: 'string',
    password2RequiredError: 'string',
    captchaCodeError: 'string',

    /**
     * Хранит состояние проверки логина
     *
     * @type {''|'checking'|'not-available'|'available'}
     */
    loginState: {
        type: 'string',
        default: ''
    },

    /**
     * Хранит состояние проверки пароля
     *
     * @type {''|'checking'|'weak'}
     */
    passwordState: {
        type: 'string',
        default: ''
    }
}, {

    /**
     * Возвращает длину пароля.
     *
     * @param {Boolean} [pluralize=false] - Флаг при котором ответ будет вида "5 символов", иначе простое число.
     * @returns {String|number}
     */
    getPasswordLength: function(pluralize) {
        var len = (this.get('password') || '').length || 0;

        return pluralize ? u.pluralize([iget2('m-agency-client-form', 'simvol', 'символ'), iget2('m-agency-client-form', 'simvola', 'символа'), iget2('m-agency-client-form', 'simvolov', 'символов'), iget2('m-agency-client-form', 'simvolov', 'символов')], len) : len;
    },

    /**
     * Возвращает текст ошибки при недопустимых символах в логине.
     *
     * @returns {String}
     */
    getLoginInvalidText: function() {
        return iget2(
            'm-agency-client-form',
            'login-dolzhen-sostoyat-iz',
            'Логин должен состоять из <b>латинских символов, цифр, одинарного дефиса или точки</b>, начинаться с буквы и заканчиваться буквой или цифрой и содержать не более <b>30</b> символов.'
        );
    },

    /**
     * Проверяет состояние введенного пароля и выставляет ошибку, если не пройдена валидация
     */
    checkPasswordState: function() {
        this.validate('password').valid || this.set('passwordState', 'error');

        // передергивание поля повтора ввода пароля при проверке пароля в основном поле
        (function(password) {
            this
                .clear('password2')
                .set('password2', password);
        })
            .call(this, this.get('password2'));
    },

    /**
     * Перепроверяет ошибку валидации пароля (pass is login) и снимает/выставляет её однократно, если требуется
     */
    recheckPasswordIsLoginError: function() {
        var error = (this.validate('password').errors || [])[0] || {};

        // если пасс равен логину или ранее была выставлена ошибка, то задаем поле модели
        (error.rule === 'isLogin' || this.get('passwordState') === 'error') &&
            (function(password) {
                this
                    .clear('password')
                    .set('password', password);
            })
                .call(this, this.get('password'));
    },

    updateValidateError: function(fieldName, validateResult) {
        var error = ((validateResult.errorsData || {})[fieldName] || [])[0] || {};

        this.set(fieldName + 'Error', '');

        if (/^(password|password2)$/.test(fieldName)) {
            this.set(fieldName + 'RequiredError', '');
        }

        fieldName === 'login' && error.rule === 'pattern' && this.set('loginState', 'invalid-login');

        this.set(
            fieldName + 'Error',
            !(/^(password|password2)$/.test(fieldName) && error.rule === 'required') ? error.text : ''
        );

        if (/^(password|password2)$/.test(fieldName)) {
            this.set(fieldName + 'RequiredError', error.rule === 'required' ? error.text : '');
        }
    }
});
