/**
 * Используется в m-banner
 */
BEM.MODEL.decl('m-banner-href', {
    modelId: {
        type: 'id',
        internal: true
    },
    //является ли объявление, которому принадлежит ссылка, новым
    isParentBannerNew: {
        type: 'boolean',
        internal: true
    },
    /**
     * протокол
     */
    url_protocol: {
        type: 'enum',
        enum: ['https://', 'http://'],
        default: 'https://'
    },
    /**
     * ссылка
     */
    href: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    needToValidate: function() {
                        // Если есть ошибки - считаем что какая-то ссылка введена
                        return this.get('required') && !this.get('hrefHasErrors');
                    },
                    value: true,
                    text: iget2('m-banner-href', 'ne-vvedena-ssylka-na', 'Не введена ссылка на сайт')
                },
                hasErrors: {
                    validate: function() {
                        return false;
                    },
                    needToValidate: function() {
                        return this.get('hrefHasErrors');
                    },
                    text: iget2('m-banner-href', 'wrong-url', 'Введена некорректная ссылка')
                },
                noTurbo: {
                    validate: function() {
                        return !u['turbo'].isLinkTurbo(this.get('href'));
                    },
                    needToValidate: function(val) {
                        return Boolean(val);
                    },
                    text: iget2('m-banner-href', 'wrong-turbolanding-url', 'Нельзя указывать ссылку на турбо-страницу')
                }
            }
        },
        preprocess: function(string) {
            return u.stripHttp(string);
        }
    },
    required: {
        type: 'boolean',
        internal: true,
        default: true
    },

    /**
     * домен
     */
    domain: {
        type: 'string',
        preprocess: function(string) {
            return u.extractDomain(string);
        }
    },
    /**
     * md5 хэш домена для проверки после сохранения
     */
    domain_sign: 'sign',
    /**
     * домен-редирект (если домен содержит редирект, тот домен, на который идёт редирект (или если редиректа, тот тот-же domain))
     */
    domain_redir: 'string',
    /**
     * md5 хэш домена-редиректа для проверки после сохранения
     */
    domain_redir_sign: 'string',
    domain_error: {
        type: 'string',
        internal: true
    },
    /**
     * Рейтинг магазина в маркете
     */
    market_rating: {
        type: 'number',
        default: -1
    },
    /**
     * флаг, есть ли в ссылке параметры--заполнители (some={param1})
     */
    isHrefHasParams: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            var href = this.get('href'),
                haveParams = !!href.match(/#([^#]*?)#/) ||
                    !!href.match(/{(param1|param2|source|source_type|position_type|position|keyword|addphrases)}/i);

            return haveParams;
        },
        dependsFrom: 'href'
    },

    /**
    * Флаг, есть ли в ссылке ошибки
     */
    hrefHasErrors: {
        type: 'boolean',
        internal: true,
        default: false
    }
}, {

    /**
     * Флаг состояния копирования модели
     */
    _copyState: false,

    /**
     * Выставляет или снимает флаг состояния копирования модели
     * @param {Boolean} state значение флага состояния копирования модели
     */
    setCopyState: function(state) {
        this._copyState = state;
    },

    /**
     * Возвращает флаг состояния копирования модели
     * @return {Boolean}
     */
    hasCopyState: function() {
        return this._copyState;
    },

    /**
     * проверяет отлична ли ссылка модели от сравниваемой
     * @param {String} initHref сравниваемая ссылка
     * @returns {Boolean}
     */
    isLinkChanged: function(initHref) {

        return initHref ? initHref != this.get('href') : false;
    },

    /**
     * сверяет домены (domain_redir и domain), проверяя наличие редиректа
     * domain_redir - куда фактически ведет ссылка, если используются адриверовские ссылки-кликеры
     * domain - домен введенной ссылки
     *
     * ВАЖНО!
     * сейчас приходится вытаскивать домен из ссылки, правильнее проверять domain и domain_redir.
     * таск на исправление аякс ответа ajaxCheckUrl - DIRECT-41544
     * @returns {Boolean}
     */
    isHrefRedirect: function() {
        var comparator = function(a, b) {
            var regExp = /(www\.)?(.*)/;

            return (a && b) ? a.match(regExp)[2].toLowerCase() == b.match(regExp)[2].toLowerCase() : true;
        };

        return !comparator(u.extractDomain(this.get('href')), this.get('domain'));
    },

    /**
     * проверяет длину домена
     * @returns {Boolean}
     */
    isDomainLengthValid: function() {

        return (this.get('domain') || this.get('domain_redir')).length <= CONSTS.MAX_DOMAIN_LENGTH;
    }
});
