describe('m-banner-href', function() {
    var model,
        constsStub;

    beforeEach(function() {
        model = BEM.MODEL.create({ name: 'm-banner-href', id: '1'}, {
            href: 'vk.com',
            url_protocol: 'https://',
            isParentBannerNew: false,
            domain: 'vk.com'
        });

        //window.CONSTS.MAX_DOMAIN_LENGTH = 35;
    });

    afterEach(function() {
        model.destruct();
    });

    describe('Валидация', function() {
        it('При заполненном поле href модель валидна', function() {
            expect(model.validate().valid).to.equal(true);
        });

        it('При незаполненном поле href модель невалидна', function() {
            model.set('href', '');

            expect(!!model.validate().valid).to.equal(false);
        });

        it('Если в href указана турбоссылка, то модель невалидна', function() {
            model.set('href', 'https://yandex.ru/turbo?text=pik_il-luga');

            expect(!!model.validate().valid).to.equal(false);
        });
    });

    describe('Метод isHrefHasParams', function() {
        [
            { href: 'mama.ru', result: false },
            { href: 'mama.ru/?param', result: false },
            { href: 'mama.ru/?param=param', result: false },
            { href: 'mama.ru/#?param=param#', result: true },
            { href: 'mama.ru/#lala?param=param#', result: true },
            { href: 'mama.ru/?param={mom}', result: false },
            { href: 'mama.ru/?param={param1}', result: true },
            { href: 'mama.ru/?param={param2}', result: true },
            { href: 'mama.ru/?param={source}', result: true },
            { href: 'mama.ru/?param={source_type}', result: true },
            { href: 'mama.ru/?param={position_type}', result: true },
            { href: 'mama.ru/?param={position}', result: true },
            { href: 'mama.ru/?param={keyword}', result: true },
            { href: 'mama.ru/?param={addphrases}', result: true }
        ].forEach(function(href) {
            it ('При поле href ' + href.href + ' возвращает ' + href.result, function() {
                model.set('href', href.href);

                expect(model.get('isHrefHasParams')).to.equal(href.result);
            });
        });
    });

    it('Метод setCopyState устанавливает флаг _copyState', function() {
        model.setCopyState(true);

        expect(model.hasCopyState()).to.equal(true);
    });

    [
        { href: 'stol.ru', result: true, text: 'отличаются' },
        { href: 'vk.com', result: false, text: 'не отличаются' }
    ].forEach(function(href) {
        it('Метод isLinkChanged возвращает ' + href.result + ', если ссылки ' + href.text, function() {
            expect(model.isLinkChanged(href.href)).to.equal(href.result);
        });
    });

    [
        { href: 'stol.ru', result: true, text: 'ссылка не ведет на домен' },
        { href: 'vk.com', result: false, text: 'ссылка ведет на домен' }
    ].forEach(function(href) {
        it('Метод isHrefRedirect возвращает ' + href.result + ', если ' + href.text, function() {
            model.set('href', href.href);

            expect(model.isHrefRedirect()).to.equal(href.result);
        });
    });

    var longdomain = new Array(10).join('cсtol') + '.ru';

    [
        { domain: 'ctol.ru', redirect: '', result: true, text: 'домен меньше ' + CONSTS.MAX_DOMAIN_LENGTH },
        { domain: longdomain, redirect: '', result: false, text: 'домен больше ' + CONSTS.MAX_DOMAIN_LENGTH },
        { domain: '', redirect: 'ctol.ru', result: true, text: 'редирект меньше ' + CONSTS.MAX_DOMAIN_LENGTH },
        { domain: '', redirect: longdomain, result: false, text: 'редирект больше ' + CONSTS.MAX_DOMAIN_LENGTH}
    ].forEach(function(test) {
        it('Метод isDomainLengthValid возвращает ' + test.result + ', если ' + test.text, function() {
            model.set('domain', test.domain);
            model.set('domain_redir', test.redirect);

            expect(model.isDomainLengthValid()).to.equal(test.result);
        });
    })
});
