BEM.MODEL.decl({ name: 'm-banner-sitelinks' }, (function() {
    var sitelinksNumber = u.consts('SITELINKS_NUMBER'),
        sitelinksFields = {
            modelId: {
                type: 'id',
                internal: true
            },
            //DIRECT-50197 - переименовать - конкатенация всех сайтлинков
            title: {
                type: 'string',
                internal: true,
                dependsFrom: [],
                calculate: function() {
                    var title = '';

                    for (var i = 0; i < sitelinksNumber; i++)
                        title += this.get('title' + i) == '*' ? '' : this.get('title' + i) || '';

                    return title;
                },
                validation: {
                    rules: {
                        maxlength: u.consts('SITELINKS_MAX_LENGTH')
                    }
                }
            }
        },
        getValidateIfHasTextFunc = function(propName) {
            return function() {
                return !this.isEmpty(propName);
            };
        },
        textPreprocess = function(value) {
            return ('' + value).replace(/\s\s*/g, ' ');
        },
        hrefPreprocess = function(value) {
            return $.trim(value).replace(/^^http(s)?:\/\//, '');
        },
        titleProp,
        hrefProp,
        descriptionProp;

    for (var i = 0; i < sitelinksNumber; i++) {

        titleProp = 'title' + i;
        hrefProp = 'href' + i;
        descriptionProp = 'description' + i;

        sitelinksFields['title'].dependsFrom.push(titleProp);

        sitelinksFields[titleProp] = {
            type: 'string',
            default: '',
            validation: {
                rules: {
                    maxlength: u.consts('ONE_SITELINK_MAX_LENGTH')
                },
                needToValidate: getValidateIfHasTextFunc(titleProp)
            },
            preprocess: textPreprocess
        };

        sitelinksFields[hrefProp] = {
            type: 'string',
            default: '',
            validation: {
                rules: {
                    maxlength: 1024
                },
                needToValidate: getValidateIfHasTextFunc(hrefProp)
            },
            preprocess: hrefPreprocess
        };

        sitelinksFields['url_protocol' + i] = {
            type: 'string',
            default: 'https://'
        };

        sitelinksFields[descriptionProp] = {
            type: 'string',
            default: '',
            validation: {
                rules: { maxlength: 60 },
                needToValidate: getValidateIfHasTextFunc(descriptionProp)
            },
            preprocess: textPreprocess
        };

        sitelinksFields['turbolanding' + i] = {
            type: 'model',
            modelName: 'dm-turbo-landing'
        };
    }

    return sitelinksFields;
})(), {
    provideData: function() {
        var data = [];

        for (var i = 0; i < u.consts('SITELINKS_NUMBER'); i++) {
            var sitelink = {
                    title: this.get('title' + i),
                    url_protocol: this.get('url_protocol' + i),
                    href: this.get('href' + i),
                    description: this.get('description' + i) || null
                },
                turbolanding = this.get('turbolanding' + i).provideData();

            turbolanding && (sitelink['turbolanding'] = turbolanding);

            data.push(sitelink);
        }

        return data;
    },

    hasTurboSitelink: function() {
        var sitelinksNumber = u.consts('SITELINKS_NUMBER'),
            hasSitelink = false,
            turbolanding;

        for (var i = 0; i < sitelinksNumber; i++) {
            turbolanding = +this.get('turbolanding' + i).get('id');

            if (turbolanding) {
                hasSitelink = true;
            }
        }

        return hasSitelink;
    }
});
