describe('m-banner-sitelinks', function() {
    var sitelinksData,
        sitelinksModel,
        sitelinksNumber = u.consts('SITELINKS_NUMBER'),
        fieldNames = ['href', 'url_protocol', 'title', 'description'];

    beforeEach(function() {
        sitelinksData = fieldNames.reduce(function(res, name) {

            for (var i = 0; i < sitelinksNumber; i++) {
                res[name + i] = 'value';
            }

            return res;
        }, {});

        sitelinksModel = BEM.MODEL.create({ name: 'm-banner-sitelinks', id: 'm-banner-sitelinks-id' }, sitelinksData);
    });

    afterEach(function() {
        sitelinksModel.destruct();
    });

    describe('m-banner-sitelinks.provideData', function() {
        it('должен вернуть массив из ' + sitelinksNumber + ' элементов', function() {
            expect(sitelinksModel.provideData().length).to.be.equal(sitelinksNumber);
        });

        context('Если модель не изменялась', function() {
            /*jshint -W083*/
            fieldNames.forEach(function(name) {
                for (var i = 0; i < sitelinksNumber; i++) {
                    (function(idx){
                        it('значение поля ' + name + ' в хеше, ' + idx +
                            ' элемента должно ровняться начальному значению ' + name + i,
                            function() {
                                expect(sitelinksModel.provideData()[idx][name])
                                    .to.be.equal(sitelinksData[name + idx]);
                            });
                    }(i));
                }
            });
            /*jshint +W083*/
        });
    });
});
